/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.delivery.v1.model.Option;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.exception.TargetClientException;
import com.adobe.target.edge.client.exception.TargetExceptionHandler;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRule;
import com.adobe.target.edge.client.ondevice.CampaignMacroReplacer;
import com.adobe.target.edge.client.ondevice.TraceHandler;
import com.adobe.target.edge.client.ondevice.collator.GeoParamsCollator;
import com.adobe.target.edge.client.utils.AllocationUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.jamsesso.jsonlogic.JsonLogic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDeviceDecisioningRuleExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OnDeviceDecisioningRuleExecutor.class);
    private static final String ALLOCATION = "allocation";
    private static final String CAMPAIGN_BUCKET_SALT = "0";
    private static final String OPTIONS = "options";
    private static final String RESPONSE_TOKEN_EXECUTION_TYPE = "activity.decisioningMethod";
    private final ClientConfig clientConfig;
    private final ObjectMapper mapper;
    private final JsonLogic jsonLogic = new JsonLogic();

    public OnDeviceDecisioningRuleExecutor(ClientConfig clientConfig, ObjectMapper mapper) {
        this.clientConfig = clientConfig;
        this.mapper = mapper;
    }

    public Map<String, Object> executeRule(Map<String, Object> localContext, RequestDetails details, String visitorId, OnDeviceDecisioningRule rule, Set<String> responseTokens, TraceHandler traceHandler) {
        localContext.put(ALLOCATION, this.computeAllocation(visitorId, rule, null));
        Object condition = rule.getCondition();
        logger.trace("details={}, context={}", (Object)details, localContext);
        try {
            String expression = this.mapper.writeValueAsString(condition);
            logger.trace("expression={}", (Object)expression);
            boolean matched = JsonLogic.truthy((Object)this.jsonLogic.apply(expression, localContext));
            if (traceHandler != null) {
                traceHandler.addCampaign(rule, localContext, matched);
            }
            if (matched) {
                return this.replaceCampaignMacros(rule, this.consequenceWithResponseTokens(responseTokens, rule, localContext), details);
            }
            return null;
        }
        catch (Exception e) {
            String message = "Hit exception while evaluating local-decisioning rule";
            logger.warn(message, (Throwable)e);
            TargetExceptionHandler handler = this.clientConfig.getExceptionHandler();
            if (handler != null) {
                handler.handleException(new TargetClientException(message, e));
            }
            return null;
        }
    }

    private double computeAllocation(String visitorId, OnDeviceDecisioningRule rule, String salt) {
        return AllocationUtils.calculateAllocation(this.clientConfig.getClient(), rule.getActivityId(), visitorId, salt == null ? CAMPAIGN_BUCKET_SALT : salt);
    }

    private Map<String, Object> consequenceWithResponseTokens(Set<String> responseTokenKeys, OnDeviceDecisioningRule rule, Map<String, Object> localContext) {
        Map<String, Object> meta;
        Map<String, Object> consequence = rule.getConsequence();
        if (consequence == null) {
            return null;
        }
        if (responseTokenKeys.isEmpty()) {
            return consequence;
        }
        Object options = consequence.get(OPTIONS);
        if (options == null) {
            return consequence;
        }
        List optionsList = (List)this.mapper.convertValue(options, (TypeReference)new TypeReference<List<Option>>(){});
        if (optionsList == null || optionsList.isEmpty()) {
            return consequence;
        }
        Option option = (Option)optionsList.get(0);
        Map<String, Object> responseTokens = option.getResponseTokens();
        responseTokens.put(RESPONSE_TOKEN_EXECUTION_TYPE, "on-device");
        Map geoContext = (Map)localContext.get("geo");
        if (geoContext != null) {
            for (Map.Entry geoEntry : geoContext.entrySet()) {
                String key = (String)geoEntry.getKey();
                String tokenKey = key.equals("region") ? "geo.state" : "geo." + key;
                if (!responseTokenKeys.contains(tokenKey) || geoEntry.getValue() == GeoParamsCollator.DEFAULT_GEO_PARAMS.get(geoEntry.getKey())) continue;
                responseTokens.put(tokenKey, geoEntry.getValue());
            }
        }
        if ((meta = rule.getMeta()) == null) {
            return this.updateOptions(consequence, optionsList);
        }
        for (Map.Entry<String, Object> metaEntry : meta.entrySet()) {
            String key = metaEntry.getKey();
            if (!responseTokenKeys.contains(key)) continue;
            responseTokens.put(key, metaEntry.getValue());
        }
        return this.updateOptions(consequence, optionsList);
    }

    private Map<String, Object> replaceCampaignMacros(OnDeviceDecisioningRule rule, Map<String, Object> consequence, RequestDetails details) {
        if (consequence == null || consequence.get(OPTIONS) == null) {
            return consequence;
        }
        CampaignMacroReplacer campaignMacroReplacer = new CampaignMacroReplacer(rule, consequence, details, this.mapper);
        return this.updateOptions(consequence, campaignMacroReplacer.getOptions());
    }

    private Map<String, Object> updateOptions(Map<String, Object> consequence, List<Option> options) {
        consequence.put(OPTIONS, this.mapper.convertValue(options, List.class));
        return consequence;
    }
}

