/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.delivery.v1.model.ExecuteRequest;
import com.adobe.target.delivery.v1.model.MboxRequest;
import com.adobe.target.delivery.v1.model.PrefetchRequest;
import com.adobe.target.delivery.v1.model.ViewRequest;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningEvaluation;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRuleSet;
import com.adobe.target.edge.client.ondevice.RuleLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class OnDeviceDecisioningEvaluator {
    private final RuleLoader ruleLoader;

    public OnDeviceDecisioningEvaluator(RuleLoader ruleLoader) {
        this.ruleLoader = ruleLoader;
    }

    public OnDeviceDecisioningEvaluation evaluateLocalExecution(TargetDeliveryRequest deliveryRequest) {
        if (deliveryRequest == null) {
            return new OnDeviceDecisioningEvaluation(false, "Given request cannot be null", null, null, null);
        }
        OnDeviceDecisioningRuleSet ruleSet = this.ruleLoader.getLatestRules();
        if (ruleSet == null) {
            return new OnDeviceDecisioningEvaluation(false, "Local-decisioning rule set not yet available", null, null, null);
        }
        List<String> remoteMboxes = this.computeRemoteMboxes(deliveryRequest, ruleSet);
        List<String> remoteViews = this.computeRemoteViews(deliveryRequest, ruleSet);
        if (!remoteMboxes.isEmpty() || !remoteViews.isEmpty()) {
            boolean haveRemoteMboxes;
            StringBuilder reason = new StringBuilder("remote activities in: ");
            boolean bl = haveRemoteMboxes = !remoteMboxes.isEmpty();
            if (haveRemoteMboxes) {
                reason.append(String.format("mboxes %s", remoteMboxes));
            }
            if (!remoteViews.isEmpty()) {
                if (haveRemoteMboxes) {
                    reason.append(", ");
                }
                reason.append(String.format("views %s", remoteViews));
            }
            return new OnDeviceDecisioningEvaluation(false, reason.toString(), ruleSet.getGlobalMbox(), remoteMboxes.isEmpty() ? null : new ArrayList<String>(remoteMboxes), (List<String>)(remoteViews.isEmpty() ? null : new ArrayList<String>(remoteViews)));
        }
        return new OnDeviceDecisioningEvaluation(true, null, ruleSet.getGlobalMbox(), null, null);
    }

    private List<String> computeRemoteMboxes(TargetDeliveryRequest deliveryRequest, OnDeviceDecisioningRuleSet ruleSet) {
        List<String> requestMboxNames = this.allMboxNames(deliveryRequest, ruleSet);
        if (requestMboxNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> remoteMboxes = new HashSet<String>();
        HashSet<String> localMboxSet = new HashSet<String>(ruleSet.getLocalMboxes());
        HashSet<String> bothMboxSet = new HashSet<String>(ruleSet.getRemoteMboxes());
        for (String mboxName : requestMboxNames) {
            if (localMboxSet.contains(mboxName) && !bothMboxSet.contains(mboxName)) continue;
            remoteMboxes.add(mboxName);
        }
        return new ArrayList<String>(remoteMboxes);
    }

    private List<String> computeRemoteViews(TargetDeliveryRequest deliveryRequest, OnDeviceDecisioningRuleSet ruleSet) {
        List<String> requestViews = this.allViewNames(deliveryRequest);
        if (requestViews.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> bothViewSet = new HashSet<String>(ruleSet.getRemoteViews());
        if (this.allViews(requestViews)) {
            return new ArrayList<String>(bothViewSet);
        }
        HashSet<String> remoteViews = new HashSet<String>();
        HashSet<String> localViewSet = new HashSet<String>(ruleSet.getLocalViews());
        for (String viewName : requestViews) {
            if (localViewSet.contains(viewName) && !bothViewSet.contains(viewName)) continue;
            remoteViews.add(viewName);
        }
        return new ArrayList<String>(remoteViews);
    }

    private List<String> allMboxNames(TargetDeliveryRequest request, OnDeviceDecisioningRuleSet ruleSet) {
        ExecuteRequest execute;
        if (request == null || ruleSet == null) {
            return Collections.emptyList();
        }
        ArrayList<String> mboxNames = new ArrayList<String>();
        String globalMbox = ruleSet.getGlobalMbox();
        PrefetchRequest prefetch = request.getDeliveryRequest().getPrefetch();
        if (prefetch != null) {
            if (prefetch.getPageLoad() != null) {
                mboxNames.add(globalMbox);
            }
            mboxNames.addAll(prefetch.getMboxes().stream().map(MboxRequest::getName).collect(Collectors.toList()));
        }
        if ((execute = request.getDeliveryRequest().getExecute()) != null) {
            if (execute.getPageLoad() != null) {
                mboxNames.add(globalMbox);
            }
            mboxNames.addAll(execute.getMboxes().stream().map(MboxRequest::getName).collect(Collectors.toList()));
        }
        return mboxNames;
    }

    private List<String> allViewNames(TargetDeliveryRequest request) {
        List<ViewRequest> views;
        if (request == null) {
            return Collections.emptyList();
        }
        ArrayList<String> viewNames = new ArrayList<String>();
        PrefetchRequest prefetch = request.getDeliveryRequest().getPrefetch();
        if (prefetch != null && (views = prefetch.getViews()) != null) {
            for (ViewRequest viewRequest : views) {
                viewNames.add(viewRequest.getName());
            }
        }
        return viewNames;
    }

    private boolean allViews(List<String> viewNames) {
        return viewNames.size() == 1 && viewNames.get(0) == null;
    }
}

