/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.delivery.v1.model.ExecuteResponse;
import com.adobe.target.delivery.v1.model.MboxRequest;
import com.adobe.target.delivery.v1.model.MboxResponse;
import com.adobe.target.delivery.v1.model.Metric;
import com.adobe.target.delivery.v1.model.MetricType;
import com.adobe.target.delivery.v1.model.Notification;
import com.adobe.target.delivery.v1.model.NotificationMbox;
import com.adobe.target.delivery.v1.model.NotificationView;
import com.adobe.target.delivery.v1.model.Option;
import com.adobe.target.delivery.v1.model.PageLoadResponse;
import com.adobe.target.delivery.v1.model.PrefetchMboxResponse;
import com.adobe.target.delivery.v1.model.PrefetchResponse;
import com.adobe.target.delivery.v1.model.Property;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.delivery.v1.model.View;
import com.adobe.target.delivery.v1.model.ViewRequest;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRule;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRuleSet;
import com.adobe.target.edge.client.ondevice.OnDeviceDecisioningRuleExecutor;
import com.adobe.target.edge.client.ondevice.TraceHandler;
import com.adobe.target.edge.client.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDeviceDecisioningDetailsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OnDeviceDecisioningDetailsExecutor.class);
    private final ClientConfig clientConfig;
    private final ObjectMapper mapper;
    private final OnDeviceDecisioningRuleExecutor ruleExecutor;

    public OnDeviceDecisioningDetailsExecutor(ClientConfig clientConfig, ObjectMapper mapper) {
        this.clientConfig = clientConfig;
        this.mapper = mapper;
        this.ruleExecutor = new OnDeviceDecisioningRuleExecutor(clientConfig, mapper);
    }

    public void executeDetails(TargetDeliveryRequest deliveryRequest, Set<String> onDeviceAllMatchingRulesMboxes, Map<String, Object> localContext, String visitorId, Set<String> responseTokens, TraceHandler traceHandler, OnDeviceDecisioningRuleSet ruleSet, RequestDetails details, PrefetchResponse prefetchResponse, ExecuteResponse executeResponse, List<Notification> notifications) {
        if (traceHandler != null) {
            traceHandler.updateRequest(deliveryRequest, details, executeResponse != null);
        }
        List<OnDeviceDecisioningRule> rules = this.detailsRules(details, ruleSet);
        String propertyToken = this.requestPropertyToken(deliveryRequest);
        boolean handledAtLeastOnce = false;
        HashSet<String> skipKeySet = new HashSet<String>();
        if (rules != null) {
            for (OnDeviceDecisioningRule rule : rules) {
                Map<String, Object> consequence;
                boolean handled;
                String ruleKey;
                if (this.propertyTokenMismatch(rule.getPropertyTokens(), propertyToken) || (ruleKey = rule.getRuleKey()) != null && skipKeySet.contains(ruleKey) || !(handled = this.handleResult(consequence = this.ruleExecutor.executeRule(localContext, details, visitorId, rule, responseTokens, traceHandler), rule, details, prefetchResponse, executeResponse, notifications, traceHandler))) continue;
                handledAtLeastOnce = true;
                if (details instanceof MboxRequest) {
                    if (onDeviceAllMatchingRulesMboxes.contains(((MboxRequest)details).getName())) continue;
                    break;
                }
                if (ruleKey == null) continue;
                skipKeySet.add(ruleKey);
            }
        }
        if (!handledAtLeastOnce) {
            this.unhandledResponse(details, prefetchResponse, executeResponse, traceHandler);
        }
    }

    private boolean handleResult(Map<String, Object> consequence, OnDeviceDecisioningRule rule, RequestDetails details, PrefetchResponse prefetchResponse, ExecuteResponse executeResponse, List<Notification> notifications, TraceHandler traceHandler) {
        logger.trace("consequence={}", consequence);
        if (consequence == null || consequence.isEmpty()) {
            return false;
        }
        if (details instanceof ViewRequest) {
            View view = (View)this.mapper.convertValue(consequence, (TypeReference)new TypeReference<View>(){});
            view.setTrace(this.currentTrace(traceHandler));
            if (prefetchResponse != null) {
                List<View> views = prefetchResponse.getViews();
                if (views == null) {
                    views = new ArrayList<View>();
                    prefetchResponse.setViews(views);
                }
                View foundView = null;
                for (View existing : views) {
                    if (!existing.getName().equals(view.getName())) continue;
                    foundView = existing;
                    break;
                }
                if (foundView == null) {
                    views.add(view);
                } else {
                    if (view.getOptions() != null) {
                        List<Option> foundOptions = foundView.getOptions();
                        if (foundOptions == null) {
                            foundOptions = new ArrayList<Option>();
                            foundView.setOptions(foundOptions);
                        }
                        foundOptions.addAll(view.getOptions());
                    }
                    if (view.getMetrics() != null) {
                        List<Metric> foundMetrics = foundView.getMetrics();
                        if (foundMetrics == null) {
                            foundMetrics = new ArrayList<Metric>();
                            foundView.setMetrics(foundMetrics);
                        }
                        foundMetrics.addAll(view.getMetrics());
                    }
                }
                return true;
            }
            return false;
        }
        List options = (List)this.mapper.convertValue(consequence.get("options"), (TypeReference)new TypeReference<List<Option>>(){});
        List metrics = (List)this.mapper.convertValue(consequence.get("metrics"), (TypeReference)new TypeReference<List<Metric>>(){});
        if (executeResponse != null) {
            Notification notification = this.createNotification(details, options);
            if (traceHandler != null) {
                traceHandler.addNotification(rule, notification);
            }
            notifications.add(notification);
        }
        if (details instanceof MboxRequest) {
            MboxRequest mbox = (MboxRequest)details;
            MboxResponse mboxResponse = prefetchResponse != null ? new PrefetchMboxResponse() : new MboxResponse();
            mboxResponse.setName(mbox.getName());
            mboxResponse.setIndex(mbox.getIndex());
            for (Option option : options) {
                if (option.getType() == null && option.getContent() == null) continue;
                if (executeResponse != null) {
                    option.setEventToken(null);
                }
                mboxResponse.addOptionsItem(option);
            }
            mboxResponse.setMetrics(metrics);
            mboxResponse.setTrace(this.currentTrace(traceHandler));
            if (prefetchResponse != null) {
                prefetchResponse.addMboxesItem((PrefetchMboxResponse)mboxResponse);
                return true;
            }
            if (executeResponse != null) {
                executeResponse.addMboxesItem(mboxResponse);
                return true;
            }
            return false;
        }
        PageLoadResponse pageLoad = null;
        if (prefetchResponse != null) {
            pageLoad = prefetchResponse.getPageLoad();
            if (pageLoad == null) {
                pageLoad = new PageLoadResponse();
                prefetchResponse.setPageLoad(pageLoad);
            }
        } else if (executeResponse != null && (pageLoad = executeResponse.getPageLoad()) == null) {
            pageLoad = new PageLoadResponse();
            executeResponse.setPageLoad(pageLoad);
        }
        if (pageLoad != null) {
            pageLoad.setTrace(this.currentTrace(traceHandler));
            for (Option option : options) {
                if (option.getType() == null && option.getContent() == null) continue;
                if (executeResponse != null) {
                    option.setEventToken(null);
                }
                pageLoad.addOptionsItem(option);
            }
            for (Metric metric : metrics) {
                if (pageLoad.getMetrics() != null && pageLoad.getMetrics().contains(metric)) continue;
                pageLoad.addMetricsItem(metric);
            }
            return true;
        }
        return false;
    }

    private void unhandledResponse(RequestDetails details, PrefetchResponse prefetchResponse, ExecuteResponse executeResponse, TraceHandler traceHandler) {
        HashMap<String, Object> trace = null;
        if (traceHandler != null) {
            trace = new HashMap<String, Object>(traceHandler.getCurrentTrace());
        }
        if (details instanceof ViewRequest) {
            View view = new View();
            view.setTrace(trace);
            prefetchResponse.addViewsItem(view);
        } else if (details instanceof MboxRequest) {
            MboxResponse response;
            MboxRequest request = (MboxRequest)details;
            if (prefetchResponse != null) {
                response = new PrefetchMboxResponse();
                prefetchResponse.addMboxesItem((PrefetchMboxResponse)response);
            } else {
                response = new MboxResponse();
                executeResponse.addMboxesItem(response);
            }
            response.setIndex(request.getIndex());
            response.setName(request.getName());
            response.setTrace(trace);
        } else {
            PageLoadResponse response = new PageLoadResponse();
            response.setTrace(trace);
            if (prefetchResponse != null) {
                prefetchResponse.setPageLoad(response);
            } else {
                executeResponse.setPageLoad(response);
            }
        }
    }

    private Notification createNotification(RequestDetails details, List<Option> options) {
        Notification notification = new Notification();
        notification.setId(UUID.randomUUID().toString());
        notification.setImpressionId(UUID.randomUUID().toString());
        notification.setType(MetricType.DISPLAY);
        notification.setTimestamp(System.currentTimeMillis());
        notification.setTokens(options.stream().map(Option::getEventToken).collect(Collectors.toList()));
        if (details instanceof ViewRequest) {
            ViewRequest vr = (ViewRequest)details;
            NotificationView view = new NotificationView();
            view.setName(vr.getName());
            view.setKey(vr.getKey());
            notification.setView(view);
        } else if (details instanceof MboxRequest) {
            MboxRequest mboxRequest = (MboxRequest)details;
            NotificationMbox mbox = new NotificationMbox();
            mbox.setName(mboxRequest.getName());
            notification.setMbox(mbox);
        }
        return notification;
    }

    private List<OnDeviceDecisioningRule> detailsRules(RequestDetails details, OnDeviceDecisioningRuleSet ruleSet) {
        if (details instanceof ViewRequest) {
            ViewRequest request = (ViewRequest)details;
            String name = request.getName();
            if (name != null) {
                return ruleSet.getRules().getViews().get(name);
            }
            return ruleSet.getRules().getViews().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (details instanceof MboxRequest) {
            return ruleSet.getRules().getMboxes().get(((MboxRequest)details).getName());
        }
        return ruleSet.getRules().getMboxes().get(ruleSet.getGlobalMbox());
    }

    private String requestPropertyToken(TargetDeliveryRequest deliveryRequest) {
        Property property = deliveryRequest.getDeliveryRequest().getProperty();
        if (property == null) {
            return null;
        }
        return property.getToken();
    }

    private boolean propertyTokenMismatch(List<String> rulePropertyTokens, String propertyToken) {
        if (rulePropertyTokens == null || rulePropertyTokens.isEmpty()) {
            return false;
        }
        if (StringUtils.isEmpty(propertyToken)) {
            return true;
        }
        return !rulePropertyTokens.contains(propertyToken);
    }

    private Map<String, Object> currentTrace(TraceHandler traceHandler) {
        if (traceHandler == null) {
            return null;
        }
        return traceHandler.getCurrentTrace();
    }
}

