/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.ClientProxyConfig;
import com.adobe.target.edge.client.exception.TargetClientException;
import com.adobe.target.edge.client.exception.TargetExceptionHandler;
import com.adobe.target.edge.client.http.JacksonObjectMapper;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningHandler;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRuleSet;
import com.adobe.target.edge.client.ondevice.RuleLoader;
import com.adobe.target.edge.client.service.TelemetryService;
import com.adobe.target.edge.client.utils.MathUtils;
import com.adobe.target.edge.client.utils.TimingTool;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuleLoader
implements RuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRuleLoader.class);
    private static final String MAJOR_VERSION = "1";
    private static final int MAX_RETRIES = 10;
    private static final String EMPTY_STRING = "";
    private OnDeviceDecisioningRuleSet latestRules;
    private String lastETag;
    private ClientConfig clientConfig;
    private TelemetryService telemetryService;
    private UnirestInstance unirestInstance = Unirest.spawnInstance();
    private Timer timer = new Timer(this.getClass().getCanonicalName());
    private boolean started = false;
    private boolean succeeded = false;
    private int retries = 0;
    private int numFetches = 0;
    private Date lastFetch = null;

    @Override
    public OnDeviceDecisioningRuleSet getLatestRules() {
        return this.latestRules;
    }

    @Override
    public synchronized void start(ClientConfig clientConfig, TelemetryService telemetryService) {
        if (!clientConfig.isOnDeviceDecisioningEnabled()) {
            return;
        }
        if (this.started) {
            return;
        }
        JacksonObjectMapper mapper = new JacksonObjectMapper();
        byte[] artifactPayload = clientConfig.getOnDeviceArtifactPayload();
        if (artifactPayload != null) {
            String payload = new String(artifactPayload, StandardCharsets.UTF_8);
            OnDeviceDecisioningRuleSet ruleSet = (OnDeviceDecisioningRuleSet)mapper.readValue(payload, (GenericType)new GenericType<OnDeviceDecisioningRuleSet>(){});
            String invalidMessage = this.invalidRuleSetMessage(ruleSet, null);
            if (invalidMessage == null) {
                this.setLatestRules(ruleSet);
                OnDeviceDecisioningHandler handler = clientConfig.getOnDeviceDecisioningHandler();
                if (handler != null && !this.succeeded) {
                    this.succeeded = true;
                    handler.onDeviceDecisioningReady();
                }
            } else {
                logger.warn(invalidMessage);
                TargetExceptionHandler handler = clientConfig.getExceptionHandler();
                if (handler != null) {
                    handler.handleException(new TargetClientException(invalidMessage));
                }
            }
        }
        this.started = true;
        this.retries = 0;
        if (this.unirestInstance != null) {
            this.unirestInstance.config().socketTimeout(clientConfig.getSocketTimeout()).connectTimeout(clientConfig.getConnectTimeout()).concurrency(clientConfig.getMaxConnectionsTotal(), clientConfig.getMaxConnectionsPerHost()).automaticRetries(clientConfig.isEnabledRetries()).enableCookieManagement(false).setObjectMapper((ObjectMapper)mapper).setDefaultHeader("Accept", "application/json");
            if (clientConfig.isProxyEnabled()) {
                ClientProxyConfig proxyConfig = clientConfig.getProxyConfig();
                if (proxyConfig.isAuthProxy()) {
                    this.unirestInstance.config().proxy(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
                } else {
                    this.unirestInstance.config().proxy(proxyConfig.getHost(), proxyConfig.getPort());
                }
                if (clientConfig.shouldArtifactRequestBypassProxyCache()) {
                    this.unirestInstance.config().setDefaultHeader("Authorization", EMPTY_STRING);
                }
            }
        }
        this.clientConfig = clientConfig;
        this.telemetryService = telemetryService;
        this.scheduleTimer(0L);
    }

    @Override
    public void stop() {
        this.timer.cancel();
        if (this.unirestInstance != null) {
            this.unirestInstance.shutDown();
        }
        this.reset();
    }

    @Override
    public void refresh() {
        this.loadRules(this.clientConfig);
        this.scheduleTimer(this.getPollingInterval());
    }

    private void reset() {
        this.started = false;
        this.succeeded = false;
        this.retries = 0;
        this.numFetches = 0;
        this.lastFetch = null;
        this.lastETag = null;
        this.latestRules = null;
    }

    private void scheduleTimer(long delay) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(this.getClass().getCanonicalName());
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean success = DefaultRuleLoader.this.loadRules(DefaultRuleLoader.this.clientConfig);
                OnDeviceDecisioningHandler handler = DefaultRuleLoader.this.clientConfig.getOnDeviceDecisioningHandler();
                if (!success && DefaultRuleLoader.this.latestRules == null) {
                    String message;
                    if (DefaultRuleLoader.this.retries++ < 10) {
                        long retryDelay = DefaultRuleLoader.this.retries * 1000;
                        message = String.format("Download of local-decisioning rules failed, retrying in %s ms", retryDelay);
                        logger.debug(message);
                        DefaultRuleLoader.this.scheduleTimer(retryDelay);
                    } else {
                        message = "Exhausted retries trying to download local-decisioning rules.";
                        logger.warn(message);
                    }
                    if (handler != null) {
                        handler.artifactDownloadFailed(new TargetClientException(message));
                    }
                } else {
                    if (handler != null && !DefaultRuleLoader.this.succeeded) {
                        DefaultRuleLoader.this.succeeded = true;
                        handler.onDeviceDecisioningReady();
                    }
                    DefaultRuleLoader.this.numFetches++;
                    DefaultRuleLoader.this.lastFetch = new Date();
                }
            }
        }, delay, this.getPollingInterval());
    }

    @Override
    public long getPollingInterval() {
        return this.clientConfig.getOnDeviceDecisioningPollingIntSecs() * 1000;
    }

    @Override
    public int getNumFetches() {
        return this.numFetches;
    }

    @Override
    public Date getLastFetch() {
        return this.lastFetch;
    }

    @Override
    public String getLocation() {
        return this.getLocalDecisioningUrl(this.clientConfig);
    }

    protected GetRequest generateRequest(ClientConfig clientConfig) {
        GetRequest getRequest = this.unirestInstance.get(this.getLocalDecisioningUrl(clientConfig));
        if (this.lastETag != null) {
            getRequest.header("If-None-Match", this.lastETag);
        }
        return getRequest;
    }

    protected HttpResponse<OnDeviceDecisioningRuleSet> executeRequest(GetRequest getRequest) {
        return getRequest.asObject((GenericType)new GenericType<OnDeviceDecisioningRuleSet>(){});
    }

    protected void setLatestRules(OnDeviceDecisioningRuleSet ruleSet) {
        this.latestRules = ruleSet;
    }

    protected void setLatestETag(String etag) {
        this.lastETag = etag;
    }

    protected boolean loadRules(ClientConfig clientConfig) {
        try {
            TargetExceptionHandler handler = clientConfig.getExceptionHandler();
            GetRequest request = this.generateRequest(clientConfig);
            TimingTool timer = new TimingTool();
            timer.timeStart("timing_execute_request");
            HttpResponse<OnDeviceDecisioningRuleSet> response = this.executeRequest(request);
            double artifactDownloadTime = timer.timeEnd("timing_execute_request");
            double artifactDownloadTimeRounded = MathUtils.roundDouble(artifactDownloadTime, 2);
            this.telemetryService.addTelemetry(artifactDownloadTimeRounded);
            if (response.getStatus() != 200) {
                if (response.getStatus() == 304) {
                    return true;
                }
                String message = "Received invalid HTTP response while getting local-decisioning rule set: " + response.getStatus() + " : " + response.getStatusText() + " from " + this.getLocalDecisioningUrl(clientConfig);
                logger.warn(message);
                if (handler != null) {
                    handler.handleException(new TargetClientException(message));
                }
                return false;
            }
            OnDeviceDecisioningRuleSet ruleSet = (OnDeviceDecisioningRuleSet)response.getBody();
            String invalidMessage = this.invalidRuleSetMessage(ruleSet, response);
            if (invalidMessage == null) {
                this.setLatestETag(response.getHeaders().getFirst("ETag"));
                this.setLatestRules(ruleSet);
                OnDeviceDecisioningHandler localHandler = clientConfig.getOnDeviceDecisioningHandler();
                if (localHandler != null) {
                    localHandler.artifactDownloadSucceeded(request == null ? null : (byte[])request.asBytes().getBody());
                }
                logger.trace("rulesList={}", (Object)this.latestRules);
                return true;
            }
            logger.warn(invalidMessage);
            if (handler != null) {
                handler.handleException(new TargetClientException(invalidMessage));
            }
            return false;
        }
        catch (Throwable t) {
            String message = "Hit exception while getting local-decisioning rule set from: " + this.getLocalDecisioningUrl(clientConfig);
            logger.warn(message, t);
            TargetExceptionHandler handler = clientConfig.getExceptionHandler();
            if (handler != null) {
                handler.handleException(new TargetClientException(message, t));
            }
            logger.error("Error while getting local-decisioning rule set", t.getCause());
            return false;
        }
    }

    private String invalidRuleSetMessage(OnDeviceDecisioningRuleSet ruleSet, HttpResponse<OnDeviceDecisioningRuleSet> response) {
        if (ruleSet == null || ruleSet.getRules() == null) {
            String message = "Unable to parse local-decisioning rule set";
            if (response != null) {
                message = message + " from: " + this.getLocalDecisioningUrl(this.clientConfig) + ", error: " + response.getParsingError();
            }
            return message;
        }
        if (ruleSet.getVersion() == null || !ruleSet.getVersion().startsWith("1.")) {
            return "Unknown rules version: " + ruleSet.getVersion();
        }
        return null;
    }

    private String getLocalDecisioningUrl(ClientConfig clientConfig) {
        return "https://" + clientConfig.getOnDeviceConfigHostname() + "/" + clientConfig.getClient() + "/" + clientConfig.getOnDeviceEnvironment().toLowerCase() + "/v" + MAJOR_VERSION + (clientConfig.getDefaultPropertyToken() != null ? "/" + clientConfig.getDefaultPropertyToken() : EMPTY_STRING) + "/rules.json";
    }
}

