/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.model;

import com.adobe.experiencecloud.ecid.visitor.VisitorState;
import com.adobe.target.delivery.v1.model.DeliveryRequest;
import com.adobe.target.delivery.v1.model.DeliveryResponse;
import com.adobe.target.edge.client.http.ResponseStatus;
import com.adobe.target.edge.client.model.ServerState;
import com.adobe.target.edge.client.model.TargetCookie;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.utils.CookieUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TargetDeliveryResponse {
    private final TargetDeliveryRequest request;
    private final DeliveryResponse response;
    private final ResponseStatus status;

    public TargetDeliveryResponse(TargetDeliveryRequest request, DeliveryResponse response, int status, String message) {
        this.request = request;
        this.response = response;
        this.status = new ResponseStatus(status, message);
    }

    public DeliveryRequest getRequest() {
        return this.request.getDeliveryRequest();
    }

    public DeliveryResponse getResponse() {
        return this.response;
    }

    public List<TargetCookie> getCookies() {
        if (this.response == null || this.response.getStatus() != 200 && this.response.getStatus() != 206) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TargetCookie> responseCookies = new ArrayList<TargetCookie>();
        CookieUtils.createTargetCookie(this.request.getSessionId(), this.response.getId().getTntId()).ifPresent(targetCookie -> responseCookies.add((TargetCookie)targetCookie));
        CookieUtils.createClusterCookie(this.response.getId().getTntId()).ifPresent(clusterCookie -> responseCookies.add((TargetCookie)clusterCookie));
        return responseCookies;
    }

    public Map<String, VisitorState> getVisitorState() {
        if (this.request.getVisitor() == null) {
            return Collections.emptyMap();
        }
        return this.request.getVisitor().getState();
    }

    public int getStatus() {
        return this.status.getStatus();
    }

    public String getMessage() {
        return this.status.getMessage();
    }

    public ResponseStatus getResponseStatus() {
        return this.status;
    }

    @JsonIgnore
    public ServerState getServerState() {
        return new ServerState(this.request.getDeliveryRequest(), this.response);
    }

    public String toString() {
        return "TargetDeliveryResponse{request=" + this.request + ", response=" + this.response + ", status=" + this.status + '}';
    }
}

