/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.model;

import com.adobe.experiencecloud.ecid.visitor.AmcvEntry;
import com.adobe.experiencecloud.ecid.visitor.CustomerState;
import com.adobe.experiencecloud.ecid.visitor.Visitor;
import com.adobe.target.delivery.v1.model.AnalyticsRequest;
import com.adobe.target.delivery.v1.model.AudienceManager;
import com.adobe.target.delivery.v1.model.AuthenticatedState;
import com.adobe.target.delivery.v1.model.Context;
import com.adobe.target.delivery.v1.model.CustomerId;
import com.adobe.target.delivery.v1.model.DeliveryRequest;
import com.adobe.target.delivery.v1.model.ExecuteRequest;
import com.adobe.target.delivery.v1.model.ExperienceCloud;
import com.adobe.target.delivery.v1.model.LoggingType;
import com.adobe.target.delivery.v1.model.Notification;
import com.adobe.target.delivery.v1.model.PrefetchRequest;
import com.adobe.target.delivery.v1.model.Property;
import com.adobe.target.delivery.v1.model.QAMode;
import com.adobe.target.delivery.v1.model.Telemetry;
import com.adobe.target.delivery.v1.model.Trace;
import com.adobe.target.delivery.v1.model.VisitorId;
import com.adobe.target.edge.client.model.DecisioningMethod;
import com.adobe.target.edge.client.model.TargetCookie;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.service.VisitorProvider;
import com.adobe.target.edge.client.utils.CollectionUtils;
import com.adobe.target.edge.client.utils.CookieUtils;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class TargetDeliveryRequestBuilder {
    private String sessionId;
    private String locationHint;
    private Visitor visitor;
    private String thirdPartyId;
    private String tntId;
    private String marketingCloudVisitorId;
    private ExperienceCloud experienceCloud;
    private Map<String, CustomerState> visitorCustomerIds;
    private List<CustomerId> targetCustomerIds;
    private String trackingServer;
    private String trackingServerSecure;
    private DecisioningMethod decisioningMethod;
    private Map<String, String> requestCookies = new HashMap<String, String>();
    private DeliveryRequest request = new DeliveryRequest();

    TargetDeliveryRequestBuilder() {
    }

    public TargetDeliveryRequestBuilder requestId(String requestId) {
        this.request.requestId(requestId);
        return this;
    }

    public TargetDeliveryRequestBuilder impressionId(String impressionId) {
        this.request.impressionId(impressionId);
        return this;
    }

    public TargetDeliveryRequestBuilder environmentId(Long environmentId) {
        this.request.environmentId(environmentId);
        return this;
    }

    public TargetDeliveryRequestBuilder property(Property property) {
        this.request.property(property);
        return this;
    }

    public TargetDeliveryRequestBuilder trace(Trace trace) {
        this.request.trace(trace);
        return this;
    }

    public TargetDeliveryRequestBuilder context(Context context) {
        this.request.context(context);
        return this;
    }

    public TargetDeliveryRequestBuilder execute(ExecuteRequest execute) {
        this.request.execute(execute);
        return this;
    }

    public TargetDeliveryRequestBuilder prefetch(PrefetchRequest prefetch) {
        this.request.prefetch(prefetch);
        return this;
    }

    public TargetDeliveryRequestBuilder notifications(List<Notification> notifications) {
        this.request.notifications(notifications);
        return this;
    }

    public TargetDeliveryRequestBuilder telemetry(Telemetry telemetry) {
        this.request.telemetry(telemetry);
        return this;
    }

    public TargetDeliveryRequestBuilder qaMode(QAMode qaMode) {
        this.request.qaMode(qaMode);
        return this;
    }

    public TargetDeliveryRequestBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public TargetDeliveryRequestBuilder locationHint(String locationHint) {
        this.locationHint = locationHint;
        return this;
    }

    public TargetDeliveryRequestBuilder visitor(Visitor visitor) {
        this.visitor = visitor;
        return this;
    }

    public TargetDeliveryRequestBuilder id(VisitorId id) {
        this.request.id(id);
        return this;
    }

    public TargetDeliveryRequestBuilder experienceCloud(ExperienceCloud experienceCloud) {
        this.experienceCloud = experienceCloud;
        return this;
    }

    public TargetDeliveryRequestBuilder cookies(List<TargetCookie> cookies) {
        if (CollectionUtils.isEmpty(cookies)) {
            return this;
        }
        cookies.stream().filter(Objects::nonNull).forEach(cookie -> this.requestCookies.put(cookie.getName(), cookie.getValue()));
        return this;
    }

    public TargetDeliveryRequestBuilder thirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
        return this;
    }

    public TargetDeliveryRequestBuilder tntId(String tntId) {
        this.tntId = tntId;
        return this;
    }

    public TargetDeliveryRequestBuilder marketingCloudVisitorId(String marketingCloudVisitorId) {
        this.marketingCloudVisitorId = marketingCloudVisitorId;
        return this;
    }

    public TargetDeliveryRequestBuilder customerIds(Map<String, CustomerState> customerIds) {
        this.visitorCustomerIds = customerIds;
        return this;
    }

    public TargetDeliveryRequestBuilder trackingServer(String trackingServer) {
        this.trackingServer = trackingServer;
        return this;
    }

    public TargetDeliveryRequestBuilder trackingServerSecure(String trackingServerSecure) {
        this.trackingServerSecure = trackingServerSecure;
        return this;
    }

    public TargetDeliveryRequestBuilder decisioningMethod(DecisioningMethod decisioningMethod) {
        this.decisioningMethod = decisioningMethod;
        return this;
    }

    public TargetDeliveryRequest build() {
        this.setTargetValues();
        this.setVisitorValues();
        this.createVisitorId();
        this.setExperienceCloudValues();
        TargetDeliveryRequest targetDeliveryRequest = TargetDeliveryRequest.fromRequest(this.request);
        targetDeliveryRequest.setLocationHint(this.locationHint);
        targetDeliveryRequest.setSessionId(this.sessionId);
        targetDeliveryRequest.setVisitor(this.visitor);
        targetDeliveryRequest.setDecisioningMethod(this.decisioningMethod);
        return targetDeliveryRequest;
    }

    private void createVisitorId() {
        if (this.request.getId() != null) {
            return;
        }
        if (StringUtils.isEmpty(this.tntId) && StringUtils.isEmpty(this.marketingCloudVisitorId) && StringUtils.isEmpty(this.thirdPartyId)) {
            return;
        }
        VisitorId visitorId = new VisitorId().tntId(this.tntId).marketingCloudVisitorId(this.marketingCloudVisitorId).thirdPartyId(this.thirdPartyId).customerIds(this.targetCustomerIds);
        this.request.id(visitorId);
    }

    private void setTargetValues() {
        String targetCookie = this.requestCookies.get("mbox");
        Map<String, String> targetCookies = CookieUtils.parseTargetCookies(targetCookie);
        this.setSessionId(targetCookies);
        this.setTntId(targetCookies);
        this.setCustomerIds();
        this.setEdgeCluster();
    }

    private void setVisitorValues() {
        String visitorCookie = this.requestCookies.get(VisitorProvider.getInstance().getVisitorCookieName());
        this.createAndSetVisitor(visitorCookie);
        Map visitorValues = this.visitor.getVisitorValues();
        AmcvEntry entry = (AmcvEntry)visitorValues.get("MCMID");
        if (entry != null) {
            this.marketingCloudVisitorId = entry.getValue();
        }
    }

    private void setExperienceCloudValues() {
        if (this.visitor == null) {
            return;
        }
        this.getOrCreateExperienceCloud();
        this.createAndSetAudienceManager(this.visitor);
        this.createAndSetAnalyticsValues(this.visitor);
        this.request.experienceCloud(this.experienceCloud);
    }

    private void createAndSetVisitor(String visitorCookie) {
        if (this.visitor != null) {
            return;
        }
        this.visitor = VisitorProvider.getInstance().createVisitor(visitorCookie);
        this.visitor.setCustomerIds(this.visitorCustomerIds);
    }

    private void getOrCreateExperienceCloud() {
        if (this.experienceCloud != null) {
            return;
        }
        this.experienceCloud = new ExperienceCloud();
    }

    private void createAndSetAudienceManager(Visitor visitor) {
        if (this.experienceCloud.getAudienceManager() != null) {
            return;
        }
        Map visitorValues = visitor.getVisitorValues();
        AmcvEntry locationHintEntry = (AmcvEntry)visitorValues.get("MCAAMLH");
        AmcvEntry blobEntry = (AmcvEntry)visitorValues.get("MCAAMB");
        if (locationHintEntry != null && blobEntry != null) {
            int locationHint = Integer.parseInt(locationHintEntry.getValue());
            String blob = blobEntry.getValue();
            AudienceManager audienceManager = new AudienceManager().blob(blob).locationHint(locationHint);
            this.experienceCloud.audienceManager(audienceManager);
        }
    }

    private void setSessionId(Map<String, String> parsedCookies) {
        if (StringUtils.isNotEmpty(this.sessionId)) {
            return;
        }
        String cookieValue = parsedCookies.get("session");
        if (StringUtils.isNotEmpty(cookieValue)) {
            this.sessionId = cookieValue;
            return;
        }
        this.sessionId = UUID.randomUUID().toString();
    }

    private void setTntId(Map<String, String> parsedCookies) {
        if (StringUtils.isNotEmpty(this.tntId)) {
            return;
        }
        this.tntId = parsedCookies.get("PC");
    }

    private void setCustomerIds() {
        if (CollectionUtils.isEmpty(this.visitorCustomerIds)) {
            return;
        }
        ArrayList<CustomerId> customerIds = new ArrayList<CustomerId>();
        for (String integrationKey : this.visitorCustomerIds.keySet()) {
            CustomerState customerState = this.visitorCustomerIds.get(integrationKey);
            CustomerId customerId = new CustomerId().id(customerState.getId()).integrationCode(integrationKey);
            switch (customerState.getAuthState()) {
                case AUTHENTICATED: {
                    customerId.setAuthenticatedState(AuthenticatedState.AUTHENTICATED);
                    break;
                }
                case LOGGED_OUT: {
                    customerId.setAuthenticatedState(AuthenticatedState.LOGGED_OUT);
                    break;
                }
                default: {
                    customerId.setAuthenticatedState(AuthenticatedState.UNKNOWN);
                }
            }
            customerIds.add(customerId);
        }
        this.targetCustomerIds = customerIds;
    }

    private void createAndSetAnalyticsValues(Visitor visitor) {
        if (this.experienceCloud.getAnalytics() != null) {
            return;
        }
        AnalyticsRequest analyticsRequest = new AnalyticsRequest().trackingServer(this.trackingServer).trackingServerSecure(this.trackingServerSecure).logging(LoggingType.SERVER_SIDE).supplementalDataId(visitor.getSupplementalDataId("target-global-mbox"));
        this.experienceCloud.analytics(analyticsRequest);
    }

    private void setEdgeCluster() {
        if (StringUtils.isNotEmpty(this.locationHint)) {
            return;
        }
        this.locationHint = this.requestCookies.get("mboxEdgeCluster");
    }
}

