/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.model;

import com.adobe.target.delivery.v1.model.DeliveryResponse;
import com.adobe.target.delivery.v1.model.ExecuteResponse;
import com.adobe.target.delivery.v1.model.MboxResponse;
import com.adobe.target.delivery.v1.model.Option;
import com.adobe.target.delivery.v1.model.OptionType;
import com.adobe.target.delivery.v1.model.PageLoadResponse;
import com.adobe.target.delivery.v1.model.PrefetchResponse;
import com.adobe.target.edge.client.Attributes;
import com.adobe.target.edge.client.model.TargetDeliveryResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TargetAttributesResponse
implements Attributes {
    private static final String GLOBAL_MBOX = "target-global-mbox";
    private final TargetDeliveryResponse response;
    private final Map<String, Map<String, Object>> content;

    public TargetAttributesResponse(TargetDeliveryResponse response) {
        this.response = response;
        this.content = TargetAttributesResponse.toMap(response);
    }

    @Override
    public Boolean getBoolean(String mbox, String key, Boolean defaultValue) {
        Map<String, Object> map = this.toMboxMap(mbox);
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Override
    public String getString(String mbox, String key) {
        Map<String, Object> map = this.toMboxMap(mbox);
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Integer getInteger(String mbox, String key, Integer defaultValue) {
        Map<String, Object> map = this.toMboxMap(mbox);
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value).intValue();
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(String mbox, String key, Double defaultValue) {
        Map<String, Object> map = this.toMboxMap(mbox);
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        return defaultValue;
    }

    @Override
    public TargetDeliveryResponse getResponse() {
        return this.response;
    }

    @Override
    public Map<String, Object> toMboxMap(String mbox) {
        return this.content.get(mbox);
    }

    @Override
    public Map<String, Map<String, Object>> toMap() {
        return this.content;
    }

    private static Map<String, Map<String, Object>> toMap(TargetDeliveryResponse targetResponse) {
        if (targetResponse == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        String globalMbox = TargetAttributesResponse.getGlobalMbox(targetResponse);
        DeliveryResponse response = targetResponse.getResponse();
        PrefetchResponse prefetchResponse = response.getPrefetch();
        ExecuteResponse executeResponse = response.getExecute();
        TargetAttributesResponse.processPrefetch(result, prefetchResponse, globalMbox);
        TargetAttributesResponse.processExecute(result, executeResponse, globalMbox);
        return TargetAttributesResponse.toReadOnlyMap(result);
    }

    private static String getGlobalMbox(TargetDeliveryResponse response) {
        String globalMbox = response.getResponseStatus().getGlobalMbox();
        return globalMbox == null ? GLOBAL_MBOX : globalMbox;
    }

    private static void processPrefetch(Map<String, Map<String, Object>> accumulator, PrefetchResponse response, String globalMbox) {
        if (response == null) {
            return;
        }
        TargetAttributesResponse.processPageLoad(accumulator, response.getPageLoad(), globalMbox);
        TargetAttributesResponse.processMboxes(accumulator, response.getMboxes());
    }

    private static void processExecute(Map<String, Map<String, Object>> accumulator, ExecuteResponse response, String globalMbox) {
        if (response == null) {
            return;
        }
        TargetAttributesResponse.processPageLoad(accumulator, response.getPageLoad(), globalMbox);
        TargetAttributesResponse.processMboxes(accumulator, response.getMboxes());
    }

    private static void processPageLoad(Map<String, Map<String, Object>> accumulator, PageLoadResponse response, String globalMbox) {
        if (response == null) {
            return;
        }
        TargetAttributesResponse.addOptions(accumulator, response.getOptions(), globalMbox);
    }

    private static <T extends MboxResponse> void processMboxes(Map<String, Map<String, Object>> accumulator, List<T> mboxes) {
        if (mboxes == null) {
            return;
        }
        for (int i = mboxes.size() - 1; i >= 0; --i) {
            MboxResponse resp = (MboxResponse)mboxes.get(i);
            String mbox = resp.getName();
            List<Option> options = resp.getOptions();
            TargetAttributesResponse.addOptions(accumulator, options, mbox);
        }
    }

    private static void addOptions(Map<String, Map<String, Object>> accumulator, List<Option> options, String mbox) {
        Map mboxContent = accumulator.computeIfAbsent(mbox, k -> new HashMap());
        for (int j = options.size() - 1; j >= 0; --j) {
            Option option = options.get(j);
            if (!TargetAttributesResponse.isJsonOption(option)) continue;
            Object contentMap = option.getContent();
            Map contentObj = (Map)contentMap;
            mboxContent.putAll(contentObj);
        }
    }

    private static boolean isJsonOption(Option option) {
        Object contentMap = option.getContent();
        return option.getType() == OptionType.JSON && contentMap instanceof Map;
    }

    private static Map<String, Map<String, Object>> toReadOnlyMap(Map<String, Map<String, Object>> map) {
        HashMap result = new HashMap(map.size());
        map.keySet().forEach(key -> result.put(key, Collections.unmodifiableMap((Map)map.get(key))));
        return Collections.unmodifiableMap(result);
    }
}

