/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.http;

import com.adobe.target.edge.client.http.DefaultTargetMetricContext;
import com.adobe.target.edge.client.http.TargetMetricContext;
import java.util.function.Consumer;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponseSummary;
import kong.unirest.MetricContext;
import kong.unirest.UniMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetMetrics
implements UniMetric {
    private static final Logger LOG = LoggerFactory.getLogger(TargetMetrics.class);
    private final Consumer<TargetMetricContext> metricContextConsumer;

    public TargetMetrics(Consumer<TargetMetricContext> metricContextConsumer) {
        this.metricContextConsumer = metricContextConsumer;
    }

    public MetricContext begin(HttpRequestSummary request) {
        long startMillis = System.currentTimeMillis();
        return (response, exception) -> {
            if (exception != null) {
                LOG.error("Response processing failed", (Throwable)exception);
                return;
            }
            this.metricContextConsumer.accept(TargetMetrics.createMetricContext(request, response, startMillis));
        };
    }

    private static TargetMetricContext createMetricContext(HttpRequestSummary request, HttpResponseSummary response, long startMillis) {
        return new DefaultTargetMetricContext(request.getUrl(), response.getStatus(), response.getStatusText(), (int)(System.currentTimeMillis() - startMillis));
    }
}

