/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.http;

import com.adobe.target.edge.client.http.DefaultTargetHttpClient;
import com.adobe.target.edge.client.http.ResponseWrapper;
import com.adobe.target.edge.client.http.TargetHttpClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kong.unirest.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHttpClientLoggingDecorator
implements TargetHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTargetHttpClient.class);
    private final TargetHttpClient delegate;

    public TargetHttpClientLoggingDecorator(TargetHttpClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T, R> ResponseWrapper<R> execute(Map<String, Object> queryParams, String url, T request, Class<R> response) {
        logger.debug("Request: Url:{} QueryParams:{} RequestBody:{}", new Object[]{url, queryParams, request});
        ResponseWrapper<R> execute = this.delegate.execute(queryParams, url, request, response);
        this.logResponse(execute.getHttpResponse());
        return execute;
    }

    @Override
    public <T, R> CompletableFuture<ResponseWrapper<R>> executeAsync(Map<String, Object> queryParams, String url, T request, Class<R> response) {
        logger.debug("AsyncRequest: Url:{} QueryParams:{} RequestBody:{}", new Object[]{url, queryParams, request});
        CompletableFuture<ResponseWrapper<R>> executeAsync = this.delegate.executeAsync(queryParams, url, request, response);
        executeAsync.thenAccept(responseWrapper -> this.logResponse(responseWrapper.getHttpResponse()));
        return executeAsync;
    }

    private <R> void logResponse(HttpResponse<R> execute) {
        Object body = execute.getBody();
        if (execute.getStatus() == 200 && body != null) {
            logger.debug("Response: ResponseBody:{}", body);
            return;
        }
        logger.error("Error occurred while fetching response from target: Status: {} Message: {} ParsingError: {} ResponseBody:{} ", new Object[]{execute.getStatus(), execute.getStatusText(), execute.getParsingError(), body});
    }

    @Override
    public void addDefaultHeader(String key, String value) {
        logger.debug("Adding default header: key:{}, value:{}", (Object)key, (Object)value);
        this.delegate.addDefaultHeader(key, value);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }
}

