/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kong.unirest.GenericType;
import kong.unirest.UnirestException;

public class JacksonObjectMapper
implements kong.unirest.ObjectMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonObjectMapper() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
    }

    public <T> T readValue(String value, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(value, valueType);
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        try {
            return (T)this.objectMapper.readValue(value, this.objectMapper.constructType(genericType.getType()));
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public String writeValue(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public ObjectMapper getMapper() {
        return this.objectMapper;
    }
}

