/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.http;

import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.ClientProxyConfig;
import com.adobe.target.edge.client.http.ApacheClientFactory;
import com.adobe.target.edge.client.http.JacksonObjectMapper;
import com.adobe.target.edge.client.http.LoggingMetricConsumer;
import com.adobe.target.edge.client.http.ResponseWrapper;
import com.adobe.target.edge.client.http.TargetHttpClient;
import com.adobe.target.edge.client.http.TargetMetrics;
import com.adobe.target.edge.client.utils.MathUtils;
import com.adobe.target.edge.client.utils.StringUtils;
import com.adobe.target.edge.client.utils.TimingTool;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.AsyncClient;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.RawResponse;
import kong.unirest.UniMetric;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.UnirestInstance;
import kong.unirest.apache.ApacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTargetHttpClient
implements TargetHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTargetHttpClient.class);
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    private UnirestInstance unirestInstance = Unirest.spawnInstance();
    private ObjectMapper serializer = new JacksonObjectMapper();
    private static final int DECIMAL_PLACES = 2;

    public DefaultTargetHttpClient(ClientConfig clientConfig) {
        Config config = this.unirestInstance.config();
        config.socketTimeout(clientConfig.getSocketTimeout()).connectTimeout(clientConfig.getConnectTimeout()).connectionTTL(Duration.ofMillis(clientConfig.getConnectionTtlMs())).concurrency(clientConfig.getMaxConnectionsTotal(), clientConfig.getMaxConnectionsPerHost()).automaticRetries(clientConfig.isEnabledRetries()).enableCookieManagement(false).setObjectMapper(this.getObjectMapper()).setDefaultHeader("Accept", "application/json");
        if (clientConfig.isLogRequestStatus()) {
            config.instrumentWith((UniMetric)new TargetMetrics(new LoggingMetricConsumer()));
        }
        if (clientConfig.getRequestInterceptor() != null) {
            config.addInterceptor(clientConfig.getRequestInterceptor());
        }
        if (clientConfig.isProxyEnabled()) {
            ClientProxyConfig proxyConfig = clientConfig.getProxyConfig();
            if (proxyConfig.isAuthProxy()) {
                config.proxy(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            } else {
                config.proxy(proxyConfig.getHost(), proxyConfig.getPort());
            }
        }
        if (clientConfig.getHttpClient() != null) {
            config.httpClient((Client)new ApacheClient(clientConfig.getHttpClient(), config));
        } else {
            config.httpClient((Client)ApacheClientFactory.initializeSyncClient(clientConfig, config));
        }
        config.asyncClient((AsyncClient)ApacheClientFactory.initializeAsyncClient(clientConfig, config));
    }

    @Override
    public void addDefaultHeader(String key, String value) {
        this.unirestInstance.config().setDefaultHeader(key, value);
    }

    @Override
    public <T, R> ResponseWrapper<R> execute(Map<String, Object> queryParams, String url, T request, Class<R> responseClass) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        HttpResponse httpResponse = ((HttpRequestWithBody)this.unirestInstance.post(url).queryString(queryParams)).body(request).asObject(this.getRawResponseFunction(responseClass, responseWrapper));
        responseWrapper.setHttpResponse(httpResponse);
        return responseWrapper;
    }

    @Override
    public <T, R> CompletableFuture<ResponseWrapper<R>> executeAsync(Map<String, Object> queryParams, String url, T request, Class<R> responseClass) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        CompletableFuture<ResponseWrapper<R>> completableFutureResponseWrapper = new CompletableFuture<ResponseWrapper<R>>();
        ((HttpRequestWithBody)this.unirestInstance.post(url).queryString(queryParams)).body(request).asObjectAsync(this.getRawResponseFunction(responseClass, responseWrapper)).thenApply(this.getCompletableFutureFunction(responseWrapper, completableFutureResponseWrapper));
        return completableFutureResponseWrapper;
    }

    private ObjectMapper getObjectMapper() {
        logger.debug("using json serializer: {}", (Object)this.serializer.getClass().getSimpleName());
        return this.serializer;
    }

    private <R> Function<HttpResponse<R>, CompletableFuture<ResponseWrapper<R>>> getCompletableFutureFunction(ResponseWrapper<R> responseWrapper, CompletableFuture<ResponseWrapper<R>> completableFutureResponseWrapper) {
        return httpResponse -> {
            responseWrapper.setHttpResponse((HttpResponse)httpResponse);
            completableFutureResponseWrapper.complete(responseWrapper);
            return completableFutureResponseWrapper;
        };
    }

    private <R> Function<RawResponse, R> getRawResponseFunction(Class<R> responseClass, ResponseWrapper<R> responseWrapper) {
        return rawResponse -> {
            String rawResponseContent;
            TimingTool timer = new TimingTool();
            timer.timeStart("timing_execute_request");
            byte[] responseAsByte = rawResponse.getContentAsBytes();
            try {
                rawResponseContent = new String(responseAsByte, this.getCharSet((RawResponse)rawResponse));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnirestException((Exception)e);
            }
            Object responseBody = this.getObjectMapper().readValue(rawResponseContent, responseClass);
            double parsingTime = timer.timeEnd("timing_execute_request");
            responseWrapper.setParsingTime(MathUtils.roundDouble(parsingTime, 2));
            responseWrapper.setResponseSize(responseAsByte.length);
            return responseBody;
        };
    }

    protected String getCharSet(RawResponse rawResponse) {
        String contentType = rawResponse.getContentType();
        String responseCharset = this.getCharsetFromContentType(contentType);
        if (StringUtils.isNotEmpty(responseCharset)) {
            return responseCharset;
        }
        return rawResponse.getConfig().getDefaultResponseEncoding();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    @Override
    public void close() {
        this.unirestInstance.shutDown();
    }

    UnirestInstance getUnirestInstance() {
        return this.unirestInstance;
    }
}

