/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.http;

import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.exception.TargetClientException;
import com.adobe.target.edge.client.http.TargetAsyncIdleConnectionMonitorThread;
import java.util.concurrent.TimeUnit;
import kong.unirest.Config;
import kong.unirest.Proxy;
import kong.unirest.apache.ApacheAsyncClient;
import kong.unirest.apache.ApacheClient;
import kong.unirest.apache.AsyncIdleConnectionMonitorThread;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;

public class ApacheClientFactory {
    public static ApacheClient initializeSyncClient(ClientConfig clientConfig, Config config) {
        PoolingHttpClientConnectionManager manager = ApacheClientFactory.createConnectionManager(clientConfig, config);
        HttpClient newClient = ApacheClientFactory.createCustomClient(clientConfig, config, manager);
        return new ApacheClient(newClient, config, manager);
    }

    public static ApacheAsyncClient initializeAsyncClient(ClientConfig clientConfig, Config config) {
        ApacheAsyncClient client;
        try {
            PoolingNHttpClientConnectionManager manager = ApacheClientFactory.createConnectionManager(config);
            TargetAsyncIdleConnectionMonitorThread monitor = new TargetAsyncIdleConnectionMonitorThread(manager, clientConfig);
            CloseableHttpAsyncClient asyncClient = ApacheClientFactory.createCustomClient(config, manager);
            asyncClient.start();
            monitor.tryStart();
            client = new ApacheAsyncClient((HttpAsyncClient)asyncClient, config, manager, (AsyncIdleConnectionMonitorThread)monitor);
        }
        catch (Exception e) {
            throw new TargetClientException("Error occurred while initializing ApacheAsyncClient", e);
        }
        return client;
    }

    private static RequestConfig toRequestConfig(Config config) {
        HttpHost proxy = ApacheClientFactory.toApacheProxy(config.getProxy());
        return RequestConfig.custom().setConnectTimeout(config.getConnectionTimeout()).setSocketTimeout(config.getSocketTimeout()).setConnectionRequestTimeout(config.getSocketTimeout()).setProxy(proxy).build();
    }

    private static CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCredentials = new BasicCredentialsProvider();
            proxyCredentials.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCredentials;
        }
        return null;
    }

    private static PoolingHttpClientConnectionManager createConnectionManager(ClientConfig clientConfig, Config config) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(ApacheClientFactory.createDefaultSyncRegistry(), null, null, null, config.getTTL(), TimeUnit.MILLISECONDS);
        manager.setMaxTotal(config.getMaxConnections());
        manager.setDefaultMaxPerRoute(config.getMaxPerRoutes());
        manager.setValidateAfterInactivity(clientConfig.getIdleConnectionValidationMs());
        return manager;
    }

    private static HttpClient createCustomClient(ClientConfig clientConfig, Config config, PoolingHttpClientConnectionManager manager) {
        HttpClientBuilder cb = HttpClients.custom().setDefaultRequestConfig(ApacheClientFactory.toRequestConfig(config)).setDefaultCredentialsProvider(ApacheClientFactory.toApacheCreds(config.getProxy())).setConnectionManager((HttpClientConnectionManager)manager).evictIdleConnections((long)clientConfig.getEvictIdleConnectionsAfterSecs(), TimeUnit.SECONDS).useSystemProperties();
        ApacheClientFactory.setOptions(cb, config);
        return cb.build();
    }

    private static Registry<ConnectionSocketFactory> createDefaultSyncRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    private static HttpHost toApacheProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        return new HttpHost(proxy.getHost(), proxy.getPort().intValue());
    }

    private static void setOptions(HttpClientBuilder cb, Config config) {
        if (!config.isAutomaticRetries()) {
            cb.disableAutomaticRetries();
        }
        if (!config.isRequestCompressionOn()) {
            cb.disableContentCompression();
        }
        if (config.useSystemProperties()) {
            cb.useSystemProperties();
        }
        if (!config.getFollowRedirects()) {
            cb.disableRedirectHandling();
        }
        if (!config.getEnabledCookieManagement()) {
            cb.disableCookieManagement();
        }
        config.getInterceptor().stream().forEach(arg_0 -> ((HttpClientBuilder)cb).addInterceptorFirst(arg_0));
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(Config config) throws Exception {
        PoolingNHttpClientConnectionManager manager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(), null, ApacheClientFactory.createDefaultAsyncRegistry(), null, null, config.getTTL(), TimeUnit.MILLISECONDS);
        manager.setMaxTotal(config.getMaxConnections());
        manager.setDefaultMaxPerRoute(config.getMaxPerRoutes());
        return manager;
    }

    private static CloseableHttpAsyncClient createCustomClient(Config config, PoolingNHttpClientConnectionManager manager) {
        HttpAsyncClientBuilder ab = HttpAsyncClientBuilder.create().setDefaultRequestConfig(ApacheClientFactory.toRequestConfig(config)).setConnectionManager((NHttpClientConnectionManager)manager).setDefaultCredentialsProvider(ApacheClientFactory.toApacheCreds(config.getProxy())).useSystemProperties();
        ApacheClientFactory.setOptions(ab, config);
        return ab.build();
    }

    private static Registry<SchemeIOSessionStrategy> createDefaultAsyncRegistry() {
        return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy()).build();
    }

    private static void setOptions(HttpAsyncClientBuilder ab, Config config) {
        if (config.useSystemProperties()) {
            ab.useSystemProperties();
        }
        if (!config.getFollowRedirects()) {
            ab.setRedirectStrategy((RedirectStrategy)new ApacheNoRedirectStrategy());
        }
        if (!config.getEnabledCookieManagement()) {
            ab.disableCookieManagement();
        }
        config.getInterceptor().forEach(arg_0 -> ((HttpAsyncClientBuilder)ab).addInterceptorFirst(arg_0));
    }

    static class ApacheNoRedirectStrategy
    implements RedirectStrategy {
        ApacheNoRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) {
            return null;
        }
    }
}

