/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client;

import com.adobe.target.delivery.v1.model.DeliveryRequest;
import com.adobe.target.delivery.v1.model.ExecuteRequest;
import com.adobe.target.delivery.v1.model.MboxRequest;
import com.adobe.target.delivery.v1.model.PrefetchRequest;
import com.adobe.target.delivery.v1.model.Property;
import com.adobe.target.edge.client.Attributes;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.TargetClient;
import com.adobe.target.edge.client.exception.TargetRequestException;
import com.adobe.target.edge.client.http.DefaultTargetHttpClient;
import com.adobe.target.edge.client.http.ResponseStatus;
import com.adobe.target.edge.client.model.DecisioningMethod;
import com.adobe.target.edge.client.model.TargetAttributesResponse;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.TargetDeliveryResponse;
import com.adobe.target.edge.client.ondevice.OnDeviceDecisioningService;
import com.adobe.target.edge.client.service.DefaultTargetService;
import com.adobe.target.edge.client.service.TargetService;
import com.adobe.target.edge.client.service.TelemetryService;
import com.adobe.target.edge.client.service.VisitorProvider;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTargetClient
implements TargetClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTargetHttpClient.class);
    private final TargetService targetService;
    private final OnDeviceDecisioningService localService;
    private final String defaultPropertyToken;
    private final DecisioningMethod defaultDecisioningMethod;

    DefaultTargetClient(ClientConfig clientConfig) {
        TelemetryService telemetryService = new TelemetryService(clientConfig);
        this.targetService = new DefaultTargetService(clientConfig, telemetryService);
        VisitorProvider.init(clientConfig.getOrganizationId());
        this.localService = new OnDeviceDecisioningService(clientConfig, this.targetService, telemetryService);
        this.defaultPropertyToken = clientConfig.getDefaultPropertyToken();
        this.defaultDecisioningMethod = clientConfig.getDefaultDecisioningMethod();
    }

    @Override
    public TargetDeliveryResponse getOffers(TargetDeliveryRequest request) {
        try {
            Objects.requireNonNull(request, "request cannot be null");
            DecisioningMethod decisioningMethod = this.getDecisioningMethod(request);
            this.updatePropertyToken(request);
            TargetDeliveryResponse targetDeliveryResponse = decisioningMethod == DecisioningMethod.ON_DEVICE || decisioningMethod == DecisioningMethod.HYBRID && this.localService.evaluateLocalExecution(request).isAllLocal() ? this.localService.executeRequest(request) : this.targetService.executeRequest(request);
            return targetDeliveryResponse;
        }
        catch (Exception e) {
            TargetRequestException targetRequestException = new TargetRequestException(e.getMessage(), e, request);
            logger.error(targetRequestException.getMessage());
            throw targetRequestException;
        }
    }

    @Override
    public CompletableFuture<TargetDeliveryResponse> getOffersAsync(TargetDeliveryRequest request) {
        try {
            Objects.requireNonNull(request, "request cannot be null");
            DecisioningMethod decisioningMethod = this.getDecisioningMethod(request);
            this.updatePropertyToken(request);
            CompletableFuture<TargetDeliveryResponse> targetDeliveryResponse = decisioningMethod == DecisioningMethod.ON_DEVICE || decisioningMethod == DecisioningMethod.HYBRID && this.localService.evaluateLocalExecution(request).isAllLocal() ? this.localService.executeRequestAsync(request) : this.targetService.executeRequestAsync(request);
            return targetDeliveryResponse;
        }
        catch (Exception e) {
            TargetRequestException targetRequestException = new TargetRequestException(e.getMessage(), e, request);
            logger.error(targetRequestException.getMessage());
            throw targetRequestException;
        }
    }

    @Override
    public ResponseStatus sendNotifications(TargetDeliveryRequest request) {
        return this.targetService.executeNotification(request);
    }

    @Override
    public CompletableFuture<ResponseStatus> sendNotificationsAsync(TargetDeliveryRequest request) {
        return this.targetService.executeNotificationAsync(request);
    }

    @Override
    public Attributes getAttributes(TargetDeliveryRequest targetRequest, String ... mboxes) {
        TargetDeliveryResponse response = this.getOffers(DefaultTargetClient.addMBoxesToRequest(targetRequest, mboxes));
        return new TargetAttributesResponse(response);
    }

    @Override
    public CompletableFuture<Attributes> getAttributesAsync(TargetDeliveryRequest targetRequest, String ... mboxes) {
        CompletableFuture<TargetDeliveryResponse> completableResponse = this.getOffersAsync(DefaultTargetClient.addMBoxesToRequest(targetRequest, mboxes));
        return completableResponse.thenApply(TargetAttributesResponse::new);
    }

    @Override
    public void close() {
        try {
            this.targetService.close();
            this.localService.stop();
        }
        catch (Exception e) {
            logger.error("Could not close TargetClient: {}", (Object)e.getMessage());
        }
    }

    private DecisioningMethod getDecisioningMethod(TargetDeliveryRequest targetRequest) {
        DecisioningMethod mode = targetRequest.getDecisioningMethod();
        if (mode != null) {
            return mode;
        }
        return this.defaultDecisioningMethod;
    }

    private void updatePropertyToken(TargetDeliveryRequest targetRequest) {
        if (StringUtils.isEmpty(this.defaultPropertyToken)) {
            return;
        }
        DeliveryRequest deliveryRequest = targetRequest.getDeliveryRequest();
        Property property = deliveryRequest.getProperty();
        if (property != null && property.getToken() != null) {
            return;
        }
        if (property == null) {
            property = new Property();
            deliveryRequest.setProperty(property);
        }
        property.setToken(this.defaultPropertyToken);
    }

    private static TargetDeliveryRequest addMBoxesToRequest(TargetDeliveryRequest targetRequest, String ... mboxes) {
        List<MboxRequest> executeMboxes;
        ExecuteRequest executeRequest;
        if (targetRequest == null || targetRequest.getDeliveryRequest() == null) {
            targetRequest = TargetDeliveryRequest.builder().decisioningMethod(DecisioningMethod.HYBRID).build();
        }
        int idx = 0;
        HashSet<String> existingMBoxNames = new HashSet<String>();
        DeliveryRequest deliveryRequest = targetRequest.getDeliveryRequest();
        PrefetchRequest prefetchRequest = deliveryRequest.getPrefetch();
        if (prefetchRequest != null && prefetchRequest.getMboxes() != null) {
            for (MboxRequest mb : prefetchRequest.getMboxes()) {
                existingMBoxNames.add(mb.getName());
            }
        }
        if ((executeRequest = deliveryRequest.getExecute()) != null && (executeMboxes = executeRequest.getMboxes()) != null) {
            for (MboxRequest mb : executeMboxes) {
                if (mb.getIndex() >= idx) {
                    idx = mb.getIndex() + 1;
                }
                existingMBoxNames.add(mb.getName());
            }
        }
        for (String mbox : mboxes) {
            if (existingMBoxNames.contains(mbox)) continue;
            if (executeRequest == null) {
                executeRequest = new ExecuteRequest();
                targetRequest.getDeliveryRequest().setExecute(executeRequest);
            }
            executeRequest.addMboxesItem(new MboxRequest().index(idx++).name(mbox));
        }
        return targetRequest;
    }
}

