/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client;

import com.adobe.target.edge.client.ClientProxyConfig;
import com.adobe.target.edge.client.exception.TargetExceptionHandler;
import com.adobe.target.edge.client.model.DecisioningMethod;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningHandler;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;

public class ClientConfig {
    private String client;
    private String organizationId;
    private String protocol;
    private String defaultUrl;
    private String clusterUrlPrefix;
    private String clusterUrlSuffix;
    private String defaultPropertyToken;
    private int socketTimeout;
    private int connectTimeout;
    private int maxConnectionsPerHost;
    private int maxConnectionsTotal;
    private int connectionTtlMs;
    private int idleConnectionValidationMs;
    private int evictIdleConnectionsAfterSecs;
    private boolean enableRetries;
    private boolean logRequests;
    private boolean logRequestStatus;
    private HttpRequestInterceptor requestInterceptor;
    private ClientProxyConfig proxyConfig;
    private TargetExceptionHandler exceptionHandler;
    private OnDeviceDecisioningHandler onDeviceDecisioningHandler;
    private DecisioningMethod defaultDecisioningMethod;
    private String onDeviceEnvironment;
    private String onDeviceConfigHostname;
    private int onDeviceDecisioningPollingIntSecs;
    private byte[] onDeviceArtifactPayload;
    private boolean telemetryEnabled;
    private List<String> onDeviceAllMatchingRulesMboxes;
    private HttpClient httpClient;
    private boolean shouldArtifactRequestBypassProxyCache;

    public String getClient() {
        return this.client;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getDefaultPropertyToken() {
        return this.defaultPropertyToken;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public int getConnectionTtlMs() {
        return this.connectionTtlMs;
    }

    public int getIdleConnectionValidationMs() {
        return this.idleConnectionValidationMs;
    }

    public int getEvictIdleConnectionsAfterSecs() {
        return this.evictIdleConnectionsAfterSecs;
    }

    public boolean isEnabledRetries() {
        return this.enableRetries;
    }

    public boolean isLogRequests() {
        return this.logRequests;
    }

    public boolean isLogRequestStatus() {
        return this.logRequestStatus;
    }

    public HttpRequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getUrl(String locationHint) {
        if (StringUtils.isNotEmpty(locationHint)) {
            return this.clusterUrlPrefix + locationHint + this.clusterUrlSuffix;
        }
        return this.defaultUrl;
    }

    public ClientProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public boolean isProxyEnabled() {
        return this.proxyConfig != null;
    }

    public TargetExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public OnDeviceDecisioningHandler getOnDeviceDecisioningHandler() {
        return this.onDeviceDecisioningHandler;
    }

    public DecisioningMethod getDefaultDecisioningMethod() {
        return this.defaultDecisioningMethod;
    }

    public String getOnDeviceEnvironment() {
        return this.onDeviceEnvironment;
    }

    public String getOnDeviceConfigHostname() {
        return this.onDeviceConfigHostname;
    }

    public int getOnDeviceDecisioningPollingIntSecs() {
        return this.onDeviceDecisioningPollingIntSecs;
    }

    public byte[] getOnDeviceArtifactPayload() {
        return this.onDeviceArtifactPayload;
    }

    public List<String> getOnDeviceAllMatchingRulesMboxes() {
        return this.onDeviceAllMatchingRulesMboxes;
    }

    public boolean isOnDeviceDecisioningEnabled() {
        return this.defaultDecisioningMethod != DecisioningMethod.SERVER_SIDE;
    }

    public static ClientConfigBuilder builder() {
        return new ClientConfigBuilder();
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public boolean shouldArtifactRequestBypassProxyCache() {
        return this.shouldArtifactRequestBypassProxyCache;
    }

    static /* synthetic */ byte[] access$2602(ClientConfig x0, byte[] x1) {
        x0.onDeviceArtifactPayload = x1;
        return x1;
    }

    public static final class ClientConfigBuilder {
        private static final String CLUSTER_PREFIX = "mboxedge";
        private static final String DELIVERY_PATH_SUFFIX = "/rest/v1/delivery";
        private String client;
        private String organizationId;
        private String serverDomain = "tt.omtrdc.net";
        private String defaultPropertyToken;
        private boolean secure = true;
        private int socketTimeout = 10000;
        private int connectTimeout = 10000;
        private int maxConnectionsPerHost = 100;
        private int maxConnectionsTotal = 200;
        private int connectionTtlMs = -1;
        private int idleConnectionValidationMs = 1000;
        private int evictIdleConnectionsAfterSecs = 20;
        private boolean enableRetries = true;
        private boolean logRequests = false;
        private boolean logRequestStatus = false;
        private HttpRequestInterceptor requestInterceptor;
        private ClientProxyConfig proxyConfig;
        private TargetExceptionHandler exceptionHandler;
        private OnDeviceDecisioningHandler onDeviceDecisioningHandler;
        private DecisioningMethod defaultDecisioningMethod = DecisioningMethod.SERVER_SIDE;
        private String onDeviceEnvironment = "production";
        private String onDeviceConfigHostname = "assets.adobetarget.com";
        private int onDeviceDecisioningPollingIntSecs = 300;
        private byte[] onDeviceArtifactPayload;
        private boolean telemetryEnabled = true;
        private List<String> onDeviceAllMatchingRulesMboxes;
        private HttpClient httpClient;
        private boolean shouldArtifactRequestBypassProxyCache = false;

        private ClientConfigBuilder() {
        }

        public ClientConfigBuilder client(String client) {
            this.client = client;
            return this;
        }

        public ClientConfigBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ClientConfigBuilder serverDomain(String serverDomain) {
            this.serverDomain = serverDomain;
            return this;
        }

        public ClientConfigBuilder defaultPropertyToken(String defaultPropertyToken) {
            this.defaultPropertyToken = defaultPropertyToken;
            return this;
        }

        public ClientConfigBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public ClientConfigBuilder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ClientConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ClientConfigBuilder maxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public ClientConfigBuilder maxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public ClientConfigBuilder connectionTtlMs(int connectionTtlMs) {
            this.connectionTtlMs = connectionTtlMs;
            return this;
        }

        public ClientConfigBuilder idleConnectionValidationMs(int idleConnectionValidationMs) {
            this.idleConnectionValidationMs = idleConnectionValidationMs;
            return this;
        }

        public ClientConfigBuilder evictIdleConnectionsAfterSecs(int evictIdleConnectionsAfterSecs) {
            this.evictIdleConnectionsAfterSecs = evictIdleConnectionsAfterSecs;
            return this;
        }

        public ClientConfigBuilder enableRetries(boolean enableRetries) {
            this.enableRetries = enableRetries;
            return this;
        }

        public ClientConfigBuilder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ClientConfigBuilder telemetryEnabled(boolean telemetryEnabled) {
            this.telemetryEnabled = telemetryEnabled;
            return this;
        }

        public ClientConfigBuilder logRequestStatus(boolean logRequestStatus) {
            this.logRequestStatus = logRequestStatus;
            return this;
        }

        public ClientConfigBuilder requestInterceptor(HttpRequestInterceptor requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public ClientConfigBuilder proxyConfig(ClientProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public ClientConfigBuilder exceptionHandler(TargetExceptionHandler handler) {
            this.exceptionHandler = handler;
            return this;
        }

        public ClientConfigBuilder onDeviceDecisioningHandler(OnDeviceDecisioningHandler handler) {
            this.onDeviceDecisioningHandler = handler;
            return this;
        }

        public ClientConfigBuilder defaultDecisioningMethod(DecisioningMethod decisioningMethod) {
            this.defaultDecisioningMethod = decisioningMethod;
            return this;
        }

        public ClientConfigBuilder onDeviceEnvironment(String environment) {
            this.onDeviceEnvironment = environment;
            return this;
        }

        public ClientConfigBuilder onDeviceConfigHostname(String hostname) {
            this.onDeviceConfigHostname = hostname;
            return this;
        }

        public ClientConfigBuilder onDeviceDecisioningPollingIntSecs(int pollingInterval) {
            this.onDeviceDecisioningPollingIntSecs = pollingInterval;
            return this;
        }

        public ClientConfigBuilder onDeviceArtifactPayload(byte[] payload) {
            this.onDeviceArtifactPayload = payload;
            return this;
        }

        public ClientConfigBuilder onDeviceAllMatchingRulesMboxes(List<String> mboxes) {
            this.onDeviceAllMatchingRulesMboxes = mboxes;
            return this;
        }

        public ClientConfigBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ClientConfigBuilder shouldArtifactRequestBypassProxyCache(boolean shouldArtifactRequestBypassProxyCache) {
            this.shouldArtifactRequestBypassProxyCache = shouldArtifactRequestBypassProxyCache;
            return this;
        }

        public ClientConfig build() {
            ClientConfig clientConfig = new ClientConfig();
            Objects.requireNonNull(this.organizationId, "organization id cannot be null");
            clientConfig.client = this.client;
            clientConfig.organizationId = this.organizationId;
            clientConfig.protocol = this.secure ? "https://" : "http://";
            clientConfig.defaultPropertyToken = this.defaultPropertyToken;
            clientConfig.connectTimeout = this.connectTimeout;
            clientConfig.maxConnectionsTotal = this.maxConnectionsTotal;
            clientConfig.socketTimeout = this.socketTimeout;
            clientConfig.enableRetries = this.enableRetries;
            clientConfig.maxConnectionsPerHost = this.maxConnectionsPerHost;
            clientConfig.connectionTtlMs = this.connectionTtlMs;
            clientConfig.idleConnectionValidationMs = this.idleConnectionValidationMs;
            clientConfig.evictIdleConnectionsAfterSecs = this.evictIdleConnectionsAfterSecs;
            clientConfig.defaultUrl = clientConfig.protocol + this.client + "." + this.serverDomain + DELIVERY_PATH_SUFFIX;
            clientConfig.clusterUrlPrefix = clientConfig.protocol + CLUSTER_PREFIX;
            clientConfig.clusterUrlSuffix = "." + this.serverDomain + DELIVERY_PATH_SUFFIX;
            clientConfig.requestInterceptor = this.requestInterceptor;
            clientConfig.logRequests = this.logRequests;
            clientConfig.logRequestStatus = this.logRequestStatus;
            clientConfig.proxyConfig = this.proxyConfig;
            clientConfig.exceptionHandler = this.exceptionHandler;
            clientConfig.onDeviceDecisioningHandler = this.onDeviceDecisioningHandler;
            clientConfig.defaultDecisioningMethod = this.defaultDecisioningMethod;
            clientConfig.onDeviceEnvironment = this.onDeviceEnvironment;
            clientConfig.onDeviceConfigHostname = this.onDeviceConfigHostname;
            clientConfig.onDeviceDecisioningPollingIntSecs = this.onDeviceDecisioningPollingIntSecs;
            ClientConfig.access$2602(clientConfig, this.onDeviceArtifactPayload);
            clientConfig.onDeviceAllMatchingRulesMboxes = this.onDeviceAllMatchingRulesMboxes;
            clientConfig.telemetryEnabled = this.telemetryEnabled;
            clientConfig.httpClient = this.httpClient;
            clientConfig.shouldArtifactRequestBypassProxyCache = this.shouldArtifactRequestBypassProxyCache;
            return clientConfig;
        }
    }
}

