/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.apache.batik.css.parser.CSSSACMediaExpression;

public class CSSSACMediaQuery {
    protected boolean not;
    protected String mediaType;
    protected int numExpressions;
    protected CSSSACMediaExpression[] expressions = new CSSSACMediaExpression[1];

    CSSSACMediaQuery(boolean bl, String string) {
        this.not = bl;
        this.mediaType = string;
    }

    public boolean isNot() {
        return this.not;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int getNumExpressions() {
        return this.numExpressions;
    }

    public void appendExpression(CSSSACMediaExpression cSSSACMediaExpression) {
        if (cSSSACMediaExpression == null) {
            return;
        }
        if (this.numExpressions == this.expressions.length) {
            CSSSACMediaExpression[] cSSSACMediaExpressionArray = this.expressions;
            this.expressions = new CSSSACMediaExpression[Math.max(this.expressions.length * 3 / 2, this.expressions.length + 1)];
            for (int i = 0; i < cSSSACMediaExpressionArray.length; ++i) {
                this.expressions[i] = cSSSACMediaExpressionArray[i];
            }
        }
        this.expressions[this.numExpressions++] = cSSSACMediaExpression;
    }

    public CSSSACMediaExpression getExpression(int n) {
        if (n < 0 || n >= this.numExpressions) {
            return null;
        }
        return this.expressions[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mediaType != null) {
            if (this.not) {
                stringBuffer.append("not ");
            }
            stringBuffer.append(this.mediaType);
            for (int i = 0; i < this.numExpressions; ++i) {
                stringBuffer.append(" and ");
                this.expressions[i].appendToStringBuffer(stringBuffer);
            }
        } else if (this.numExpressions > 0) {
            for (int i = 0; i < this.numExpressions - 1; ++i) {
                this.expressions[i].appendToStringBuffer(stringBuffer);
                stringBuffer.append(" and ");
            }
            this.expressions[this.numExpressions - 1].appendToStringBuffer(stringBuffer);
        }
        return stringBuffer.toString();
    }
}

