/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.text.PluralRules;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;

public class PluralRulesLoader {
    private final Map rulesIdToRules = new HashMap();
    private Map localeIdToRulesId;
    public static final PluralRulesLoader loader = new PluralRulesLoader();

    private PluralRulesLoader() {
    }

    public ULocale[] getAvailableULocales() {
        Set keys = this.getLocaleIdToRulesIdMap().keySet();
        ULocale[] locales = new ULocale[keys.size()];
        int n = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            locales[n++] = ULocale.createCanonical((String)iter.next());
        }
        return locales;
    }

    private Map getLocaleIdToRulesIdMap() {
        if (this.localeIdToRulesId == null) {
            try {
                UResourceBundle pluralb = this.getPluralBundle();
                UResourceBundle localeb = pluralb.get("locales");
                this.localeIdToRulesId = new TreeMap();
                for (int i = 0; i < localeb.getSize(); ++i) {
                    UResourceBundle b = localeb.get(i);
                    String id = b.getKey();
                    String value = b.getString().intern();
                    this.localeIdToRulesId.put(id, value);
                }
            }
            catch (MissingResourceException e) {
                this.localeIdToRulesId = new HashMap();
            }
        }
        return this.localeIdToRulesId;
    }

    public String getRulesIdForLocale(ULocale locale) {
        int ix;
        Map idMap = this.getLocaleIdToRulesIdMap();
        String localeId = ULocale.canonicalize(locale.getBaseName());
        String rulesId = null;
        while (null == (rulesId = (String)idMap.get(localeId)) && (ix = localeId.lastIndexOf("_")) != -1) {
            localeId = localeId.substring(0, ix);
        }
        return rulesId;
    }

    public PluralRules getRulesForRulesId(String rulesId) {
        PluralRules rules = (PluralRules)this.rulesIdToRules.get(rulesId);
        if (rules == null) {
            try {
                UResourceBundle pluralb = this.getPluralBundle();
                UResourceBundle rulesb = pluralb.get("rules");
                UResourceBundle setb = rulesb.get(rulesId);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < setb.getSize(); ++i) {
                    UResourceBundle b = setb.get(i);
                    if (i > 0) {
                        sb.append("; ");
                    }
                    sb.append(b.getKey());
                    sb.append(": ");
                    sb.append(b.getString());
                }
                rules = PluralRules.parseDescription(sb.toString());
            }
            catch (ParseException e) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.rulesIdToRules.put(rulesId, rules);
        }
        return rules;
    }

    public UResourceBundle getPluralBundle() throws MissingResourceException {
        return ICUResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", "plurals", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
    }

    public PluralRules forLocale(ULocale locale) {
        String rulesId = this.getRulesIdForLocale(locale);
        if (rulesId == null || rulesId.trim().length() == 0) {
            return PluralRules.DEFAULT;
        }
        PluralRules rules = this.getRulesForRulesId(rulesId);
        if (rules == null) {
            rules = PluralRules.DEFAULT;
        }
        return rules;
    }
}

