/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetASCII;
import com.adobe.agl.charset.CharsetICU;
import com.adobe.agl.text.UnicodeSet;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class Charset88591
extends CharsetASCII {
    public Charset88591(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoder88591((CharsetICU)this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoder88591((CharsetICU)this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        setFillIn.add(0, 255);
    }

    class CharsetEncoder88591
    extends CharsetASCII.CharsetEncoderASCII {
        public CharsetEncoder88591(CharsetICU cs) {
            super(Charset88591.this, cs);
        }

        protected final CoderResult encodeLoopCoreOptimized(CharBuffer source, ByteBuffer target, char[] sourceArray, byte[] targetArray, int oldSource, int offset, int limit, boolean flush) {
            int i;
            int ch = 0;
            for (i = oldSource; i < limit && ((ch = sourceArray[i]) & 0xFF00) == 0; ++i) {
                targetArray[i + offset] = (byte)ch;
            }
            if ((ch & 0xFF00) != 0) {
                source.position(i + 1);
                target.position(i + offset);
                return this.encodeMalformedOrUnmappable(source, ch, flush);
            }
            return null;
        }

        protected final CoderResult encodeLoopCoreUnoptimized(CharBuffer source, ByteBuffer target, boolean flush) throws BufferUnderflowException, BufferOverflowException {
            char ch;
            while (((ch = source.get()) & 0xFF00) == 0) {
                target.put((byte)ch);
            }
            return this.encodeMalformedOrUnmappable(source, ch, flush);
        }
    }

    class CharsetDecoder88591
    extends CharsetASCII.CharsetDecoderASCII {
        public CharsetDecoder88591(CharsetICU cs) {
            super(Charset88591.this, cs);
        }

        protected CoderResult decodeLoopCoreOptimized(ByteBuffer source, CharBuffer target, byte[] sourceArray, char[] targetArray, int oldSource, int offset, int limit) {
            for (int i = oldSource; i < limit; ++i) {
                targetArray[i + offset] = (char)(sourceArray[i] & 0xFF);
            }
            return null;
        }

        protected CoderResult decodeLoopCoreUnoptimized(ByteBuffer source, CharBuffer target) throws BufferUnderflowException, BufferOverflowException {
            while (true) {
                target.put((char)(source.get() & 0xFF));
            }
        }
    }
}

