/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fmdita.api.baselines;

import com.adobe.fmdita.api.Services;
import com.adobe.fmdita.service.ConfigManagerUtil;
import com.adobe.fmdita.service.OSGIServiceUtil;
import com.adobe.fmdita.versioncontext.VersionContextManager;
import com.day.cq.workflow.WorkflowException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.sling.api.resource.ResourceResolverFactory;

public class BaselineUtils {
    private static boolean autoCreateConfig;
    private static ConfigManagerUtil cfgMgr;

    public static String createBaseline(Session session, String sourcePath, String baselineTitle, String label, LinkedHashMap directContext, LinkedHashMap indirectContext) throws ItemExistsException, Exception {
        BaselineUtils.populateAutoCreateConfig();
        ResourceResolverFactory resolverFactory = Services.getInstance().getResourceResolverFactory();
        if (directContext == null || directContext.isEmpty()) {
            directContext.put(VersionContextManager.LABEL, label);
            directContext.put(VersionContextManager.LATEST, true);
        }
        if (indirectContext == null || indirectContext.isEmpty()) {
            indirectContext.put(VersionContextManager.LABEL, label);
            indirectContext.put(VersionContextManager.PICK_AUTOMATICALLY, null);
        }
        return com.adobe.fmdita.baselines.BaselineUtils.createBaselineGeneric((ResourceResolverFactory)resolverFactory, (Session)session, (String)sourcePath, (String)baselineTitle, (boolean)autoCreateConfig, (LinkedHashMap)directContext, (LinkedHashMap)indirectContext);
    }

    public static String createBaseline(Session session, String sourcePath, String baselineTitle, Date versionDate) throws RepositoryException, WorkflowException, Exception {
        BaselineUtils.populateAutoCreateConfig();
        ResourceResolverFactory resolverFactory = Services.getInstance().getResourceResolverFactory();
        return com.adobe.fmdita.baselines.BaselineUtils.createBaselineForGivenDateAndTime((ResourceResolverFactory)resolverFactory, (Session)session, (String)sourcePath, (String)baselineTitle, (Date)versionDate, (boolean)autoCreateConfig);
    }

    public static void applyLabel(Session session, String sourcePath, String baselineName, String label) throws RepositoryException, WorkflowException, Exception {
        com.adobe.fmdita.baselines.BaselineUtils.applyLabelToVersionsInBaseline((Session)session, (String)sourcePath, (String)baselineName, (String)label);
    }

    public static Map<String, String> deleteLabel(Session session, String sourcePath, String baselineName, String label) throws RepositoryException, WorkflowException, Exception {
        Map resultMap = com.adobe.fmdita.baselines.BaselineUtils.deleteLabelInBaseline((Session)session, (String)sourcePath, (String)baselineName, (String)label);
        return resultMap;
    }

    public static List<String> getLabels(Session session, String sourcePath) {
        List labels = com.adobe.fmdita.baselines.BaselineUtils.getAllLabels((Session)session, (String)sourcePath);
        return labels;
    }

    private static void populateAutoCreateConfig() {
        cfgMgr = (ConfigManagerUtil)OSGIServiceUtil.getService(BaselineUtils.class, ConfigManagerUtil.class);
        autoCreateConfig = PropertiesUtil.toBoolean((Object)cfgMgr.getConfig("fm2dita.auocreateversion"), (boolean)false);
    }
}

