/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.api.exception;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsPortalException
extends Exception {
    private static final long serialVersionUID = -7363820328483991171L;
    private final Logger log = LoggerFactory.getLogger(FormsPortalException.class);
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle("errorMessages");
    private String code;
    private Object[] messageArgs;

    public FormsPortalException() {
    }

    public FormsPortalException(String code) {
        this.code = code;
    }

    public FormsPortalException(String code, Object[] args) {
        this.code = code;
        this.messageArgs = args;
    }

    public FormsPortalException(Throwable cause) {
        super(cause);
    }

    public FormsPortalException(String code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public FormsPortalException(String code, Throwable cause, Object[] args) {
        super(cause);
        this.code = code;
        this.messageArgs = args;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        String message = null;
        try {
            if (this.code == null) {
                return super.getMessage();
            }
            String messageString = RESOURCES.getString(this.code);
            message = this.messageArgs != null ? MessageFormat.format(messageString, this.messageArgs) : messageString;
        }
        catch (Exception e) {
            this.log.error("Exception caught in fetching error message ", (Throwable)e);
        }
        return this.code + (message == null ? "" : ": " + message);
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(Object[] messageArgs) {
        if (messageArgs != null) {
            this.messageArgs = Arrays.copyOf(messageArgs, messageArgs.length);
        }
    }
}

