/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.fdfl.api.GuideModelTransformer;
import com.adobe.aemds.guide.fdfl.utils.AdaptiveFormUtil;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideWCMUtils;
import com.adobe.aemds.guide.utils.TranslationUtils;
import com.adobe.cq.forms.core.components.models.form.FormContainer;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.service.FormDataWrapper;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.components.Toolbar;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.SimpleBindings;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideUtils.class);
    private static final int ID_LENGTH = 16;
    private static final Pattern defaultAEMRequestParameters = Pattern.compile("^((sling|cq):.*|:cq_csrf_token)$");

    public static String getGuideContainerPath(SlingHttpServletRequest request, Resource resource) {
        String guideContainerPath = null;
        String guideContainerNodeName = "guideContainer";
        String containerParamValue = request.getParameter("guideContainerName");
        if (containerParamValue != null) {
            guideContainerNodeName = containerParamValue;
        } else if (GuideContainerThreadLocal.getGuideContainerName() != null) {
            guideContainerNodeName = GuideContainerThreadLocal.getGuideContainerName();
        } else {
            logger.debug("Guide container name not found in ThreadLocal.");
        }
        try {
            Resource guideContainerResource;
            Resource currentResource;
            ResourceResolver resolver = request.getResourceResolver();
            for (currentResource = resource; currentResource != null && !currentResource.getResourceType().equals("cq:Page"); currentResource = currentResource.getParent()) {
                String normalizedNodeType = GuideUtils.getNormalizedNodeType(currentResource.getResourceType(), currentResource.getResourceSuperType());
                if (!GuideConstants.CONTAINER_RESOURCES.contains(normalizedNodeType) && !GuideUtils.isGuideContainerResource(currentResource)) continue;
                guideContainerPath = currentResource.getPath();
                break;
            }
            if (guideContainerPath == null && currentResource != null && currentResource.getResourceType().equals("cq:Page")) {
                guideContainerPath = resource.getPath() + "/" + guideContainerNodeName;
            }
            if ((guideContainerResource = request.getResourceResolver().getResource(guideContainerPath)) == null) {
                guideContainerPath = null;
            } else {
                ValueMap properties = ResourceUtil.getValueMap((Resource)guideContainerResource);
                String guideRef = (String)properties.get("guideRef", null);
                if (guideRef != null && guideRef.length() != 0) {
                    String path = GuideUtils.guideRefToGuidePath(guideRef);
                    Resource guideContainer = request.getResourceResolver().getResource(path);
                    if (guideContainer != null) {
                        guideContainerPath = path;
                    } else {
                        logger.error("No guide found in guide reference present in guide container");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GuideException("No guide Container found", e);
        }
        return guideContainerPath;
    }

    public static String guideSomToComponentName(@Nonnull String som) {
        String componentName = null;
        if (som != null) {
            componentName = som.substring(som.lastIndexOf(".") + 1, som.lastIndexOf("["));
        }
        return componentName;
    }

    public static List getFileAttachmentList(SlingHttpServletRequest request, String guideContainerPath) {
        ResourceResolver resourceResolver;
        Resource formContainerResource;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        GuideModelTransformer guideModelTransformer = (GuideModelTransformer)bindings.getSling().getService(GuideModelTransformer.class);
        List<Object> fileAttachments = new ArrayList();
        if (guideModelTransformer != null && (formContainerResource = (resourceResolver = request.getResourceResolver()).getResource(guideContainerPath)) != null) {
            String locale = GuideUtils.getLocale(request, formContainerResource);
            JSONObject guideJson = guideModelTransformer.exportGuideJsonObject(formContainerResource, null, new Locale(locale));
            String guideJsonString = guideJson != null ? guideJson.toString() : "";
            fileAttachments = GuideUtils.getFileAttachmentList(guideJsonString);
        }
        return fileAttachments;
    }

    public static ArrayList<String> getOptions(String keyValueString, String key, I18n i18n, boolean removeEscaping, Resource formResource) {
        ArrayList<String> splitValues = new ArrayList<String>();
        String value = keyValueString.trim();
        if (value.length() > 0) {
            String optionValue;
            String optionKey;
            boolean endLoop = true;
            int pos = -1;
            int start = 0;
            do {
                if ((pos = value.indexOf(61, start)) > 0 && value.charAt(pos - 1) == '\\') {
                    start = pos + 1;
                    endLoop = false;
                    continue;
                }
                endLoop = true;
            } while (!endLoop);
            if (pos == -1) {
                optionKey = value;
                optionValue = value;
            } else {
                optionKey = value.substring(0, pos);
                optionValue = value.substring(pos + 1);
            }
            if (removeEscaping) {
                optionKey = optionKey.replace("\\=", "=");
                optionValue = optionValue.replace("\\=", "=");
            }
            String translatedString = null;
            if (formResource != null && TranslationUtils.isNewTranslation(formResource.getValueMap())) {
                translatedString = GuideUtils.translateOrReturnOriginal(keyValueString, key, i18n, formResource);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)keyValueString, (CharSequence)translatedString)) {
                    translatedString = GuideUtils.translateOrReturnOriginal(optionValue, i18n);
                }
            } else {
                translatedString = GuideUtils.translateOrReturnOriginal(optionValue, key, i18n, formResource);
            }
            splitValues.add(optionKey);
            splitValues.add(translatedString);
        } else {
            splitValues.add("");
            splitValues.add("");
        }
        return splitValues;
    }

    public static List<JSONObject> getFileAttachmentList(@Nonnull String guideJsonString) {
        List<Object> fileAttachmentList = new ArrayList<JSONObject>();
        try {
            fileAttachmentList = (List)AdaptiveFormUtil.getComponentsFromAFTemplateJson((String)guideJsonString, (String)"guideFileUpload", new ArrayList());
        }
        catch (GuideException ex) {
            logger.error("[AF] Unable to parse json while getting file attachment list", (Throwable)ex);
        }
        return fileAttachmentList;
    }

    public static FormDataWrapper getFormDataObject(SlingHttpServletRequest request) {
        String data = request.getParameter("data");
        String contentType = request.getParameter("contentType");
        ArrayList<FileAttachmentWrapper> fileAttachmentWrappers = new ArrayList<FileAttachmentWrapper>();
        RequestParameter[] fileAttachmentBindRefsRequestParams = request.getRequestParameters("fileAttachmentBindRefs");
        RequestParameter[] fileAttachmentsRequestParams = request.getRequestParameters("fileAttachments");
        if (fileAttachmentBindRefsRequestParams != null && fileAttachmentsRequestParams != null) {
            for (int attachmentIdx = 0; attachmentIdx < fileAttachmentsRequestParams.length; ++attachmentIdx) {
                RequestParameter fileAttachment = fileAttachmentsRequestParams[attachmentIdx];
                RequestParameter fileAttachmentBindRef = fileAttachmentBindRefsRequestParams[attachmentIdx];
                FileAttachmentWrapper fileAttachmentWrapper = null;
                try {
                    if (GuideUtils.hasBinaryData(fileAttachment)) {
                        fileAttachmentWrapper = new FileAttachmentWrapper(fileAttachment.getFileName(), fileAttachment.getContentType(), fileAttachment.get(), fileAttachmentBindRef.getString());
                    } else {
                        String fileMetadata = fileAttachment.getString();
                        JSONObject fileMetadataJson = new JSONObject(fileMetadata);
                        fileAttachmentWrapper = new FileAttachmentWrapper(fileMetadataJson.getString("name"), fileMetadataJson.getString("contentType"), null, fileMetadataJson.getString("data"), fileAttachmentBindRef.getString());
                    }
                }
                catch (JSONException jsonException) {
                    logger.error("Exception in parsing json content from request file parameters");
                    throw new GuideException((Exception)((Object)jsonException));
                }
                fileAttachmentWrapper.setUuid(UUID.randomUUID().toString());
                fileAttachmentWrappers.add(fileAttachmentWrapper);
            }
        }
        return new FormDataWrapper(data, contentType, fileAttachmentWrappers);
    }

    private static boolean hasBinaryData(RequestParameter fileAttachment) throws JSONException {
        if (!"application/json".equals(fileAttachment.getContentType())) {
            return true;
        }
        String fileContent = fileAttachment.getString();
        JSONObject fileContentJson = new JSONObject(fileContent);
        return fileContentJson.isNull("data") || fileContentJson.isNull("name") || fileContentJson.isNull("contentType");
    }

    public static boolean setToolbarLabel(String name, String title, EditContext editContext, SlingHttpServletRequest request) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (name != null) {
                tb.add(0, (Toolbar.Item)new Toolbar.Label(title + name));
            }
            tb.add(1, (Toolbar.Item)new Toolbar.Separator());
            return true;
        }
        return false;
    }

    public static String encodeForHtml(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTML(str);
        return result == null ? "" : result;
    }

    public static String encodeForHtml(String str, org.apache.sling.xss.XSSAPI xssapi) {
        String result = xssapi.encodeForHTML(str);
        return result == null ? "" : result;
    }

    @Deprecated
    public static String encodeForHtmlAttr(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTMLAttr(str);
        return result == null ? "" : result;
    }

    public static String encodeForJSString(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForJSString(str);
        return result == null ? "" : result;
    }

    public static String filterHtml(String str, XSSAPI xssapi) {
        String result = xssapi.filterHTML(str);
        return result == null ? "" : result;
    }

    public static String getDefaultLocale(Resource resource) {
        String defaultLocale = "en";
        try {
            Node parentNode;
            Node containerNode = (Node)resource.adaptTo(Node.class);
            if (containerNode != null && (parentNode = containerNode.getParent()) != null && parentNode.hasProperty("jcr:language")) {
                defaultLocale = parentNode.getProperty("jcr:language").getString();
            }
        }
        catch (Exception e) {
            logger.error("Unable to access Page Locale", (Throwable)e);
        }
        return defaultLocale;
    }

    public static String getThemeClientLibName(Resource resource) {
        try {
            String theme;
            Node containerNode = (Node)resource.adaptTo(Node.class);
            if (containerNode != null && containerNode.hasProperty("themeRef") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(theme = containerNode.getProperty("themeRef").getString()))) {
                Resource themeResource = resource.getResourceResolver().getResource(theme + "/jcr:content/metadata");
                if (themeResource != null) {
                    Node themeNode = (Node)themeResource.adaptTo(Node.class);
                    if (themeNode != null && themeNode.hasProperty("clientlibCategory")) {
                        return themeNode.getProperty("clientlibCategory").getString();
                    }
                } else {
                    logger.warn("Unable to retrieve the theme resource: " + theme);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to get Client lib name: " + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getLocale(SlingHttpServletRequest request, Resource guideContainerResource) {
        try {
            String defaultLocale = GuideUtils.getDefaultLocale(guideContainerResource);
            String localeCode = null;
            String clientLibPrefix = "guides.I18N";
            Object locale = null;
            SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
            HtmlLibraryManager clientlibManager = (HtmlLibraryManager)bindings.getSling().getService(HtmlLibraryManager.class);
            boolean clientLibForDefaultLocaleExists = clientlibManager.getLibraries(new String[]{clientLibPrefix + "." + defaultLocale}, null, true, false).toArray().length > 0;
            String acceptLang = GuideUtils.getLocaleParamFromRequest(request);
            if (acceptLang == null || acceptLang.trim().isEmpty()) {
                acceptLang = defaultLocale;
            }
            String[] locales = org.apache.commons.lang3.StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                String[] categories;
                Collection libraries;
                boolean clientLibForLocaleExists;
                localeCode = org.apache.commons.lang3.StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                boolean bl = clientLibForLocaleExists = (libraries = clientlibManager.getLibraries(categories = new String[]{clientLibPrefix + "." + localeCode}, null, true, false)).toArray().length > 0;
                if (clientLibForLocaleExists) {
                    return localeCode;
                }
                if (splitLocale.length <= 1) continue;
                categories = new String[]{clientLibPrefix + "." + splitLocale[0].toLowerCase()};
                libraries = clientlibManager.getLibraries(categories, null, true, false);
                boolean bl2 = clientLibForLocaleExists = libraries.toArray().length > 0;
                if (!clientLibForLocaleExists) continue;
                return splitLocale[0].toLowerCase();
            }
            if (clientLibForDefaultLocaleExists) {
                return defaultLocale;
            }
            return "en";
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public static I18n getI18n(SlingHttpServletRequest request, Resource guideFieldResource) {
        I18n i18n = null;
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            String containerPath;
            String acceptLang = GuideUtils.getAcceptLang(request);
            if (GuideUtils.isEditableTemplateResource(guideFieldResource).booleanValue()) {
                String formAssetPath = resourceResolver.resolve((HttpServletRequest)request, request.getRequestURI()).getPath();
                formAssetPath = formAssetPath.substring(request.getContextPath().length());
                String formPath = formAssetPath.replace("/content/dam/formsanddocuments/", "/content/forms/af/");
                guideFieldResource = resourceResolver.getResource(formPath);
            }
            if ((containerPath = GuideUtils.getGuideContainerPath(request, guideFieldResource)) == null || containerPath.isEmpty()) {
                containerPath = GuideUtils.getGuideContainerPathFromResource(request, guideFieldResource);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)containerPath)) {
                Locale locale = new Locale(acceptLang);
                if (WCMMode.fromRequest((ServletRequest)request) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)request) == WCMMode.DESIGN) {
                    String baseName = TranslationUtils.getDictionaryPath(resourceResolver, containerPath);
                    i18n = new I18n(request.getResourceBundle(baseName, locale));
                } else {
                    i18n = new I18n(GuideUtils.getResourceBundle(request, guideFieldResource, locale));
                }
            } else {
                i18n = request != null ? new I18n(request.getResourceBundle(request.getLocale())) : new I18n(request.getResourceBundle(null));
            }
        }
        catch (Exception e) {
            logger.error("There was certainly some problem in geti18n api", (Throwable)e);
        }
        return i18n;
    }

    public static ResourceBundle getResourceBundle(SlingHttpServletRequest request, Resource guideContainerResource, Locale desiredLocale) {
        String guideContainerPath = GuideUtils.getGuideContainerPath(request, guideContainerResource);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)guideContainerPath)) {
            guideContainerPath = GuideUtils.getGuideContainerPathFromResource(request, guideContainerResource);
        }
        String baseName = TranslationUtils.getDictionaryPath(request.getResourceResolver(), guideContainerPath);
        Resource baseResource = request.getResourceResolver().getResource(baseName);
        if (GuideUtils.isDesiredLocaleDictPresent(baseResource, desiredLocale).booleanValue()) {
            return request.getResourceBundle(baseName, desiredLocale);
        }
        return null;
    }

    public static Boolean isDesiredLocaleDictPresent(Resource baseResource, Locale desiredLocale) {
        if (baseResource != null) {
            for (Resource childResource : baseResource.getChildren()) {
                String lang = (String)childResource.getValueMap().get("jcr:language", null);
                String desiredLocaleString = org.apache.commons.lang3.StringUtils.replace((String)desiredLocale.toString().toLowerCase(), (String)"_", (String)"-");
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)desiredLocaleString, (CharSequence)lang) && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)lang, (CharSequence)desiredLocaleString)) continue;
                return true;
            }
        }
        return false;
    }

    public static I18n getI18n(ResourceBundleProvider resourceBundleProvider, Resource containerResource, Locale locale) {
        if (resourceBundleProvider != null && containerResource != null && locale != null) {
            return new I18n(resourceBundleProvider.getResourceBundle(containerResource.getPath(), locale));
        }
        return null;
    }

    public static String getDataMimeType(Resource formResource) {
        GuideContainer guideContainerBean;
        GuideSchemaType schemaType;
        String mimeType = "application/xml";
        if (formResource != null && (schemaType = (guideContainerBean = GuideContainer.from(formResource)).getSchema()) != null && (GuideSchemaType.JSON.equals((Object)schemaType) || GuideSchemaType.FDM.equals((Object)schemaType))) {
            mimeType = "application/json";
        }
        return mimeType;
    }

    public static String guideRefToGuidePath(String guideRefPath) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)guideRefPath, (CharSequence)"/content/dam/formsanddocuments/")) {
            return "/content/forms/af/" + org.apache.commons.lang3.StringUtils.substringAfter((String)guideRefPath, (String)"/content/dam/formsanddocuments/") + "/jcr:content/guideContainer";
        }
        return guideRefPath;
    }

    public static String guideRefToDocPath(String guideRefPath) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)guideRefPath, (CharSequence)"/content/dam/formsanddocuments/")) {
            return GuideUtils.convertADAssetPathToWebChannelPagePath(guideRefPath) + "/jcr:content/guideContainer";
        }
        return guideRefPath;
    }

    public static String convertFMAssetPathToFormPagePath(String FMAssetPath) {
        return org.apache.commons.lang3.StringUtils.replace((String)FMAssetPath, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
    }

    public static String convertGuideContainerPathToFMAssetPath(String guideContainerPath) {
        String fmPath = org.apache.commons.lang3.StringUtils.substringBefore((String)guideContainerPath, (String)"/jcr:content/guideContainer");
        String retVal = GuideUtils.removeChannelNameFromEndIfExist(fmPath);
        retVal = org.apache.commons.lang3.StringUtils.replace((String)retVal, (String)"/content/forms/af/", (String)"/content/dam/formsanddocuments/", (int)1);
        return retVal;
    }

    public static String removeChannelNameFromEndIfExist(String pagePath) {
        String retVal = pagePath;
        retVal = org.apache.commons.lang3.StringUtils.substringBefore((String)retVal, (String)"/channels/");
        retVal = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)retVal, (String)"/jcr:content");
        return retVal;
    }

    public static String convertGuideContainerPathToFMAssetMetadataPath(String guideContainerPath) {
        String fmAssetMetadataPath = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainerPath);
        fmAssetMetadataPath = fmAssetMetadataPath + "/jcr:content/metadata";
        return fmAssetMetadataPath;
    }

    public static String getDoRTemplateRef(String guideContainerPath, String runtimeLocale, ResourceResolver resourceResolver) {
        String formDAMAssetMetadataPath = GuideUtils.convertGuideContainerPathToFMAssetMetadataPath(guideContainerPath);
        Resource containerResource = resourceResolver.getResource(guideContainerPath);
        Resource formMetadataResource = resourceResolver.getResource(formDAMAssetMetadataPath);
        String dorTemplateRef = "";
        if (formMetadataResource != null) {
            ValueMap metadata = formMetadataResource.getValueMap();
            dorTemplateRef = (String)metadata.get("xdpRef", (Object)"");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dorTemplateRef)) {
                dorTemplateRef = (String)metadata.get((Object)"dorTemplateRef");
                String dorType = (String)metadata.get("dorType", (Object)"");
                if ("generate".equals(dorType)) {
                    dorTemplateRef = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainerPath) + "/jcr:content/renditions/dorTemplate/" + runtimeLocale;
                } else if ("none".equals(dorType)) {
                    dorTemplateRef = "";
                }
            }
        } else if (containerResource != null) {
            if (GuideUtils.isEditableTemplateResource(containerResource).booleanValue()) {
                ValueMap vm = containerResource.getValueMap();
                dorTemplateRef = (String)vm.get("dorTemplateRef", (Object)"");
            } else {
                logger.info("[AF] Could not find DAM asset for the adaptive form {} while checking if DOR is configured", (Object)guideContainerPath);
            }
        }
        return dorTemplateRef;
    }

    public static boolean isXDPValid(Resource guideContainer) {
        if (guideContainer == null) {
            return false;
        }
        GuideContainer guideContainerBean = GuideContainer.from(guideContainer);
        if (!GuideSchemaType.XDP.equals((Object)guideContainerBean.getSchema())) {
            return false;
        }
        String xdpRef = guideContainerBean.getSchemaRef();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xdpRef)) {
            return false;
        }
        return guideContainerBean.getResource().getResourceResolver().getResource(xdpRef) != null;
    }

    public static boolean isMetaTemplateValid(ResourceResolver resourceResolver, String metaTemplateRef) {
        if (resourceResolver == null) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)metaTemplateRef)) {
            return false;
        }
        return resourceResolver.getResource(metaTemplateRef) != null;
    }

    public static String getMetaTemplateRef(Resource guideContainerResource) {
        ValueMap map;
        if (guideContainerResource != null && !GuideUtils.isGuideContainerResource(guideContainerResource)) {
            return "";
        }
        ValueMap guideContainerProperties = guideContainerResource.getValueMap();
        String metaTemplateRef = (String)guideContainerProperties.get("metaTemplateRef", (Object)"");
        Resource print = GuideUtils.getPrintNodeResource(guideContainerResource);
        if (print != null && (map = print.getValueMap()).containsKey((Object)"metaTemplateRef")) {
            metaTemplateRef = (String)map.get("metaTemplateRef", (Object)"");
        }
        return metaTemplateRef;
    }

    public static Resource getPrintNodeResource(Resource guideContainer) {
        return GuideUtils.isCoreComponentBasedForm(guideContainer) ? guideContainer.getChild("fd:view/print") : guideContainer.getChild("view/print");
    }

    public static boolean isCoreComponentBasedForm(Resource guideContainer) {
        return guideContainer != null && guideContainer.getValueMap() != null && "2.1".equals(guideContainer.getValueMap().get((Object)"fd:version"));
    }

    public static boolean isGuideContainerResource(Resource resource) {
        return GuideWCMUtils.isGuideContainerResource(resource);
    }

    public static boolean isV2GuideContainerResource(Resource resource) {
        return resource.isResourceType("core/fd/components/form/container/v2/container") || resource.isResourceType("core/fd/components/form/container/v1/container") || "form".equals(resource.getValueMap().get("fieldType", (Object)""));
    }

    public static boolean isTargetEnabled(Resource guideContainerResource) {
        ValueMap props = (ValueMap)guideContainerResource.getParent().adaptTo(ValueMap.class);
        return (Boolean)props.get("targetEnabled", (Object)false);
    }

    public static boolean isAdobeTargetConfigured(Resource resource) {
        HierarchyNodeInheritanceValueMap valueMap = new HierarchyNodeInheritanceValueMap(resource);
        Object cloudserviceConfigs = valueMap.getInherited("cq:cloudserviceconfigs", String[].class);
        if (cloudserviceConfigs != null) {
            for (String cloudserviceConfig : (String[])cloudserviceConfigs) {
                if (!cloudserviceConfig.startsWith("/etc/cloudservices/testandtarget")) continue;
                return true;
            }
        }
        return false;
    }

    public static SlingHttpServletResponse processInternalPostOnRestEndPoint(SlingHttpServletRequest request, SlingHttpServletResponse response, String postUrl) {
        CustomParameterRequest wrappedRequest = null;
        CustomResponse wrappedResponse = null;
        try {
            ParameterMap wrappedParameterMap = GuideUtils.prepareWrappedRequestWithDataXMLAndAttachments(request);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            wrappedResponse = new CustomResponse(response);
            request.getRequestDispatcher(postUrl).forward((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        catch (Exception e) {
            logger.error("Some Problem While Posting to rest End Point", (Throwable)e);
        }
        return wrappedResponse;
    }

    private static ParameterMap prepareWrappedRequestWithDataXMLAndAttachments(SlingHttpServletRequest request) {
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        try {
            for (Map.Entry param : originalParams.entrySet()) {
                RequestParameter[] rpm = (RequestParameter[])param.getValue();
                if (rpm != null && rpm.length > 0 && !rpm[0].isFormField()) {
                    FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
                    fileAttachments.add(fileAttachment);
                }
                if (!defaultAEMRequestParameters.matcher((CharSequence)param.getKey()).matches()) continue;
                wrappedParameterMap.put(param.getKey(), param.getValue());
            }
            if (fileAttachments.size() > 0) {
                RequestParameter[] attachments = new RequestParameter[fileAttachments.size()];
                int index = 0;
                for (FileAttachmentWrapper fileAttachment : fileAttachments) {
                    attachments[index++] = new FileRequestParameter(fileAttachment.getFileName(), IOUtils.toByteArray((InputStream)fileAttachment.getInputStream()), fileAttachment.getContentType());
                }
                wrappedParameterMap.put("attachments", attachments);
            }
            wrappedParameterMap.put("dataXml", originalParams.getValues("jcr:data"));
        }
        catch (Exception e) {
            logger.error("Not Able to make internal post req parameter", (Throwable)e);
        }
        return wrappedParameterMap;
    }

    public static boolean checkIfForms(Resource resource) {
        return GuideUtils.checkIfForms(resource, false);
    }

    public static boolean checkIfForms(Resource resource, boolean isV2) {
        Resource pageContent = resource.getChild("jcr:content");
        if (pageContent != null) {
            Resource guideContainer = pageContent.getChild("guideContainer");
            if (guideContainer != null) {
                Resource guideContainerMergedResource = (Resource)guideContainer.adaptTo(TemplatedResource.class);
                if (guideContainerMergedResource == null) {
                    guideContainerMergedResource = guideContainer;
                } else {
                    logger.warn("GuideContainer resource has been locked in the editable template for the form - " + resource.getPath());
                }
                return isV2 ? GuideUtils.isV2GuideContainerResource(guideContainerMergedResource) : GuideUtils.isGuideContainerResource(guideContainerMergedResource);
            }
            Page currentPage = (Page)resource.adaptTo(Page.class);
            if (currentPage != null) {
                Template template = currentPage.getTemplate();
                if (template == null) {
                    return false;
                }
                if (template.hasStructureSupport()) {
                    Resource res = (Resource)pageContent.adaptTo(TemplatedResource.class);
                    if (res == null) {
                        return false;
                    }
                    Iterator it = res.listChildren();
                    while (it.hasNext()) {
                        Resource child = (Resource)it.next();
                        String name = child.getName();
                        if (!"guideContainer".equals(name)) continue;
                        logger.warn("GuideContainer resource has been locked in the editable template for the form - " + resource.getPath());
                        return isV2 ? GuideUtils.isV2GuideContainerResource(child) : GuideUtils.isGuideContainerResource(child);
                    }
                }
            }
        }
        return false;
    }

    public static boolean checkIfFormsTemplate(Resource resource) {
        return GuideUtils.checkIfFormsTemplate(resource, false);
    }

    public static boolean checkIfFormsTemplate(Resource resource, boolean checkIfV2) {
        Resource templateContent = resource.getChild("jcr:content");
        if (templateContent != null) {
            ValueMap templateGuideContainerValueMap;
            String guideContainerVersion;
            Resource templateGuideContainer;
            ValueMap templateContentValueMap = templateContent.getValueMap();
            String guideComponentType = (String)templateContentValueMap.get("guideComponentType", (Object)"");
            if (!checkIfV2 ? guideComponentType != null && guideComponentType.length() > 0 : (templateGuideContainer = templateContent.getChild("guideContainer")) != null && "2.1".equals(guideContainerVersion = (String)(templateGuideContainerValueMap = templateGuideContainer.getValueMap()).get("fd:version", (Object)""))) {
                return true;
            }
        }
        return false;
    }

    public static String getThemeContentRef(Resource guideContainerResource) {
        ValueMap vmap = guideContainerResource.getValueMap();
        String themeRef = (String)vmap.get("themeRef", String.class);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)themeRef)) {
            themeRef = themeRef + "/jcr:content";
        }
        return themeRef;
    }

    public static boolean isWebChannel(Resource resource) {
        String channel;
        Page page;
        if (resource == null) {
            return false;
        }
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        return pageManager != null && (page = pageManager.getContainingPage(resource)) != null && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"web", (CharSequence)(channel = (String)page.getContentResource().getValueMap().get((Object)"fd:channelType")));
    }

    public static void setMasterAuthoringConfig(Map<String, Object> authoringConfig, ValueMap resourceProps) {
        String masterPath;
        if (resourceProps != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(masterPath = (String)resourceProps.get("cq:master", (Object)"")))) {
            authoringConfig.put("master", masterPath);
        }
    }

    public static boolean isValidFormResource(ResourceResolver resourceResolver, String formPath, String formType) {
        if ("".equals(formPath)) {
            return false;
        }
        if (resourceResolver == null) {
            return false;
        }
        Resource formResource = resourceResolver.getResource(formPath);
        if (formResource == null) {
            return false;
        }
        Resource jcrContent = formResource.getChild("jcr:content");
        if (jcrContent == null) {
            return false;
        }
        ValueMap props = jcrContent.getValueMap();
        return (Integer)props.get(formType, (Object)0) == 1;
    }

    public static Boolean isEditableTemplateResource(Resource resource) {
        Resource pageParent;
        Boolean result = false;
        Resource pageResource = GuideUtils.getPageResource(resource);
        if (pageResource != null && "cq:Template".equals((pageParent = pageResource.getParent()).getResourceType())) {
            result = pageParent.getChild("initial") != null && pageParent.getChild("policies") != null && pageParent.getChild("structure") != null;
        }
        return result;
    }

    private static void walkThroughContent(List<String> list, Resource elementResource, String resourceToBeFound) {
        if (elementResource != null) {
            Iterator iter = elementResource.listChildren();
            while (iter.hasNext()) {
                Resource current = (Resource)iter.next();
                String normalizedNodeType = GuideUtils.getNormalizedNodeType(current.getResourceType(), current.getResourceSuperType());
                if (resourceToBeFound.equals(normalizedNodeType)) {
                    list.add(current.getPath());
                }
                GuideUtils.walkThroughContent(list, current, resourceToBeFound);
            }
        }
    }

    public static String getNormalizedNodeType(String resourceType, String resourceSuperType) {
        String normalizedType = null;
        if (resourceType == null && resourceSuperType == null) {
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"fd/")) {
            normalizedType = resourceType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceType.substring(6);
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"fd/")) {
            normalizedType = resourceSuperType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceSuperType.substring(6);
        }
        return normalizedType;
    }

    public static Boolean isOldResponsiveLayout(Resource panelResource) {
        boolean isPanel;
        boolean bl = isPanel = panelResource != null && (panelResource.isResourceType("fd/af/components/panel") || panelResource.isResourceType("fd/af/components/rootPanel"));
        if (!isPanel) {
            return null;
        }
        Resource layoutResource = panelResource.getChild("layout");
        if (layoutResource == null) {
            return null;
        }
        String layoutResourceType = layoutResource.getResourceType();
        if ("fd/af/layouts/gridFluidLayout".equals(layoutResourceType)) {
            return Boolean.TRUE;
        }
        if ("fd/af/layouts/gridFluidLayout2".equals(layoutResourceType)) {
            return Boolean.FALSE;
        }
        Resource itemsResource = panelResource.getChild("items");
        if (itemsResource != null && itemsResource.hasChildren()) {
            for (Resource itemResource : itemsResource.getChildren()) {
                Boolean isOldResponsiveLayout = GuideUtils.isOldResponsiveLayout(itemResource);
                if (isOldResponsiveLayout == null) continue;
                return isOldResponsiveLayout;
            }
        }
        return null;
    }

    public static String translateOrReturnOriginal(String original, I18n i18n) {
        return GuideUtils.translateOrReturnOriginal(original, null, i18n, ValueMap.EMPTY);
    }

    public static String translateOrReturnOriginal(String value, String key, I18n i18n, @Nullable ValueMap properties) {
        if (i18n != null) {
            String localizedkey;
            String nameSpacedkey;
            if (properties != null && TranslationUtils.isNewTranslation(properties)) {
                nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties);
                localizedkey = i18n.getVar(nameSpacedkey);
            } else {
                nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties).replaceAll("\r", "");
                localizedkey = i18n.getVar(nameSpacedkey);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)localizedkey, (CharSequence)nameSpacedkey)) {
                    nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties);
                    localizedkey = i18n.getVar(nameSpacedkey);
                }
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)localizedkey, (CharSequence)nameSpacedkey)) {
                    nameSpacedkey = GuideUtils.getNamespacedKeys(org.apache.commons.lang3.StringUtils.strip((String)value), key, properties);
                    localizedkey = i18n.getVar(nameSpacedkey);
                }
            }
            if (!nameSpacedkey.equals(localizedkey)) {
                return localizedkey;
            }
        }
        return value;
    }

    public static String translateOrReturnOriginal(String original, String key, I18n i18n, @Nullable Resource formResource) {
        return GuideUtils.translateOrReturnOriginal(original, key, i18n, formResource != null ? formResource.getValueMap() : null);
    }

    public static String getGuideName(Resource rsrc) throws GuideException {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name == null || name.isEmpty()) {
            String resourceName = "";
            if (rsrc != null && rsrc.getName() != null) {
                resourceName = rsrc.getName();
                if (resourceName.startsWith("guide")) {
                    resourceName = resourceName.substring("guide".length());
                }
                resourceName = resourceName + Calendar.getInstance().getTimeInMillis();
            }
            GuideUtils.setGuideName(rsrc, resourceName);
            name = rsrc.getName();
        }
        return name;
    }

    private static void setGuideName(Resource rsrc, String name) throws GuideException {
        block5: {
            Session currentSession = (Session)rsrc.getResourceResolver().adaptTo(Session.class);
            String path = rsrc.getPath();
            try {
                if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)path, (CharSequence)"/libs") && currentSession.hasPermission(path, "set_property")) {
                    ModifiableValueMap modifiableMap = (ModifiableValueMap)rsrc.adaptTo(ModifiableValueMap.class);
                    modifiableMap.put((Object)"name", (Object)name);
                    try {
                        rsrc.getResourceResolver().commit();
                        break block5;
                    }
                    catch (PersistenceException e) {
                        logger.error("unable to set name property on " + path, (Throwable)e);
                        throw new GuideException((Exception)((Object)e));
                    }
                }
                logger.error("user has no write permission on the node " + path + ". Adaptive Form will not work properly");
            }
            catch (RepositoryException e) {
                logger.error("unable to check the permissions for setting property on " + path, (Throwable)e);
                throw new GuideException((Exception)((Object)e));
            }
        }
    }

    public static String getGuideNodeHtmlId(Resource elementResource) {
        return GuideUtils.getGuideNodeHtmlId(elementResource, null);
    }

    public static String getGuideNodeHtmlId(Resource elementResource, String fragPrefixId) {
        String path = elementResource.getPath();
        if (!path.contains("/guideContainer")) {
            logger.debug("getGuideNodeHtmlId-path does not have guideContainer:" + path);
            return path;
        }
        String nodeHtmlId = null;
        String fragPrefixidString = null;
        if (fragPrefixId == null) {
            GuideFragmentHolder guideFragmentHolder = null;
            try {
                guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
                if (guideFragmentHolder != null) {
                    fragPrefixidString = guideFragmentHolder.getFragPrefixID();
                }
            }
            catch (Exception e) {
                logger.error("Error while getting thread local from GuideUtils", (Throwable)e);
            }
        } else {
            fragPrefixidString = fragPrefixId;
        }
        nodeHtmlId = fragPrefixidString != null && fragPrefixidString.length() > 0 ? GuideUtils.generateIdForFragmentNodes(path, fragPrefixidString) : GuideUtils.generateIdForGuideNodes(path, elementResource);
        return GuideUtils.manipulateNodeHtmlId(nodeHtmlId);
    }

    private static String generateIdForGuideNodes(String path, Resource elementResource) {
        String nodeHtmlId = null;
        String containerName = "guideContainer";
        if (elementResource != null) {
            containerName = GuideUtils.getContainerNodeName(elementResource);
        }
        nodeHtmlId = elementResource != null && GuideUtils.isGuideContainerResource(elementResource) ? containerName : containerName + "-" + StringUtils.substringAfter((String)path, (String)("/" + containerName + "/"));
        return nodeHtmlId;
    }

    private static String generateIdForFragmentNodes(String path, String fragPrefix) {
        return fragPrefix + StringUtils.substringAfter((String)path, (String)"/rootPanel/items/");
    }

    private static String manipulateNodeHtmlId(String nodeHtmlId) {
        return nodeHtmlId.replaceAll("/items/", "-").replaceAll("/", "-").replaceAll("\\.", "-") + "__";
    }

    private static String getContainerNodeName(Resource elementResource) {
        Resource parent;
        String containerName = GuideContainerThreadLocal.getGuideContainerName();
        if (containerName != null) {
            return containerName;
        }
        logger.debug("Guide container name not found in ThreadLocal.");
        if (GuideUtils.isGuideContainerResource(elementResource)) {
            logger.debug("Container name retrieved from node structure: " + elementResource.getName());
            return elementResource.getName();
        }
        for (parent = elementResource.getParent(); parent != null && !GuideUtils.isGuideContainerResource(parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            String parentName = parent.getName();
            logger.debug("Container name retrieved from node structure: " + parentName);
            return parentName;
        }
        return "";
    }

    public static String getRedirectUrl(String redirectUrl, String formPath) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)redirectUrl) && redirectUrl.matches("^(https?)://.+")) {
            return redirectUrl;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            int lastSlash = redirectUrl.lastIndexOf(47);
            if (redirectUrl.indexOf(46, lastSlash) == -1) {
                redirectUrl = redirectUrl + ".html";
            }
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formPath)) {
            redirectUrl = formPath + "." + "guideThankYouPage.html";
        }
        return redirectUrl;
    }

    public static String convertFMAssetPathToContainerPath(String fragRef) {
        fragRef = StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
        fragRef = fragRef + "/jcr:content" + "/" + "guideContainer";
        return fragRef;
    }

    public static Resource getRootPanel(Resource resource) {
        try {
            if (resource != null) {
                for (Resource item : resource.getChildren()) {
                    String valueOfResourceType;
                    ValueMap valueMap = (ValueMap)item.adaptTo(ValueMap.class);
                    if (valueMap.get((Object)"sling:resourceType") == null || !"fd/af/components/rootPanel".equals(valueOfResourceType = (String)valueMap.get((Object)"sling:resourceType"))) continue;
                    return item;
                }
            }
        }
        catch (Exception e) {
            logger.error("error in getting root panel via guide json", (Throwable)e);
        }
        return null;
    }

    public static Map<String, Object> getLayoutProperties(SlingHttpServletRequest request, Resource elementResource, String cmpName) throws PersistenceException {
        if (elementResource == null) {
            return null;
        }
        Resource layoutnode = null;
        ResourceResolver resourceResolver = null;
        if (request != null) {
            resourceResolver = request.getResourceResolver();
        }
        Iterator iter = null;
        if (cmpName == null) {
            Resource parentRes = elementResource.getParent();
            iter = elementResource.getParent().listChildren();
        } else {
            iter = elementResource.listChildren();
        }
        while (iter.hasNext() && layoutnode == null) {
            Resource current = (Resource)iter.next();
            if (!current.getName().equals("layout")) continue;
            layoutnode = current;
        }
        if (layoutnode == null) {
            if (resourceResolver == null) {
                return null;
            }
            HashMap<String, String> layoutmap = new HashMap<String, String>();
            String RT_GUIDES_LAYOUT_PREFIX = "/libs/fd/af/layouts/";
            String DEFAULT_LAYOUT_GUIDECONTAINER = "defaultGuideLayout";
            String DEFAULT_LAYOUT_ROOTPANEL = "panel/tabbedPanelLayout";
            String DEFAULT_LAYOUT_PANEL = "gridFluidLayout2";
            String RT_GUIDES_LAYOUT_GUIDECONTAINER = "/libs/fd/af/layouts/defaultGuideLayout";
            String RT_GUIDES_LAYOUT_ROOTPANEL = "/libs/fd/af/layouts/panel/tabbedPanelLayout";
            String RT_GUIDES_LAYOUT_PANEL = "/libs/fd/af/layouts/gridFluidLayout2";
            layoutmap.put("guideContainer", "/libs/fd/af/layouts/defaultGuideLayout");
            layoutmap.put("rootPanel", "/libs/fd/af/layouts/panel/tabbedPanelLayout");
            layoutmap.put("panel", "/libs/fd/af/layouts/gridFluidLayout2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                String resourceType = (String)layoutmap.get(cmpName);
                map.put("sling:resourceType", resourceType);
                String nodeName = "layout";
                resourceResolver.create(elementResource, "layout", map);
            }
            catch (PersistenceException re) {
                logger.error("Unable to create missing layout element for guide node " + elementResource, (Throwable)re);
                throw new GuideException((Exception)((Object)re));
            }
            finally {
                if (resourceResolver.hasChanges()) {
                    resourceResolver.refresh();
                }
            }
            return map;
        }
        return ResourceUtil.getValueMap(layoutnode);
    }

    public static String getFragPrefixString(Resource fragRefNode, String previousPrefixId) {
        String fragPrefix = null;
        try {
            String pathAfterRootPanel = StringUtils.substringAfter((String)fragRefNode.getPath(), (String)"/rootPanel/items/");
            if (StringUtils.isNotEmpty((String)previousPrefixId)) {
                fragPrefix = previousPrefixId + pathAfterRootPanel + "/";
            } else {
                fragPrefix = GuideUtils.generateIdForGuideNodes(fragRefNode.getPath(), fragRefNode);
                fragPrefix = fragPrefix + "/items/";
            }
        }
        catch (Exception e) {
            logger.error("Error while getting fragRef prefix string", (Throwable)e);
        }
        return fragPrefix;
    }

    public static boolean setEmbedFragButton(String title, EditContext editContext, SlingHttpServletRequest request, String fragRef, String currentPanelPath, String bindRef) {
        if (editContext != null) {
            Toolbar tb;
            EditConfig editConfig = editContext.getEditConfig();
            XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
            if (editConfig != null && (tb = editConfig.getToolbar()) != null) {
                if (title != null) {
                    tb.add((Toolbar.Item)new Toolbar.Separator());
                    fragRef = org.apache.commons.lang3.StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
                    String handler = "function(){guidelib.author.editConfigListeners.embedFragment(\"" + fragRef + "\", \"" + currentPanelPath + "\" ,\"" + bindRef + "\");}";
                    tb.add((Toolbar.Item)new Toolbar.Button(title, handler));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean setButtonForPanel(String title, EditContext editContext, SlingHttpServletRequest request, String currentPanelPath, String bindRef, String handler) {
        return GuideUtils.setButtonForPanel(title, editContext, request, currentPanelPath, bindRef, handler, null);
    }

    public static boolean setButtonForPanel(String title, EditContext editContext, SlingHttpServletRequest request, String currentPanelPath, String bindRef, String handler, Integer index) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (index == null) {
                index = tb.size();
            }
            if (title != null) {
                tb.add(index.intValue(), (Toolbar.Item)new Toolbar.Separator());
                tb.add(index + 1, (Toolbar.Item)new Toolbar.Button(title, handler));
            }
            return true;
        }
        return false;
    }

    public static GuidePanel getRootPanel(Resource resource, SlingHttpServletRequest slingRequest) {
        Iterator iter = resource.listChildren();
        GuidePanel rootPanel = null;
        ResourceResolver resourceResolver = resource.getResourceResolver();
        while (iter.hasNext() && rootPanel == null) {
            Resource current = (Resource)iter.next();
            String name = current.getName();
            if (!"rootPanel".equals(name)) continue;
            rootPanel = new GuidePanel();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("resource", (Object)current);
            bindings.put("request", (Object)slingRequest);
            rootPanel.init(bindings);
        }
        return rootPanel;
    }

    public static String getAcceptLang(SlingHttpServletRequest request) {
        if (request == null) {
            return "en";
        }
        String language = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        String afLang = GuideUtils.getLocaleParamFromRequest(request);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afLang)) {
            language = GuideUtils.getAcceptLang(afLang, bindings);
        }
        return org.apache.commons.lang3.StringUtils.isEmpty(language) ? GuideUtils.getDefaultLocale(request) : language;
    }

    private static String getDefaultLocale(SlingHttpServletRequest request) {
        try {
            Resource guideContainerResource;
            ResourceResolver guideResourceResolver;
            String path;
            Resource resource = request.getResource();
            if (resource != null && (path = GuideUtils.getGuideContainerPath(request, resource)) != null && !path.isEmpty() && (guideResourceResolver = request.getResourceResolver()) != null && (guideContainerResource = guideResourceResolver.getResource(path)) != null) {
                return GuideUtils.getDefaultLocale(guideContainerResource);
            }
        }
        catch (Exception e) {
            logger.error("Guide Resource not found", (Throwable)e);
        }
        return "en";
    }

    private static String getAcceptLang(String locale, SlingBindings bindings) {
        String acceptLang = locale;
        if (bindings != null) {
            GuideLocalizationService guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class);
            String[] supportedLocales = guideLocalizationService.getSupportedLocales();
            String[] supportedLocalesSanitized = GuideUtils.sanitizeLocaleList(supportedLocales);
            String[] locales = org.apache.commons.lang3.StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                int index;
                String localeCode = org.apache.commons.lang3.StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                if ((index = Arrays.asList(supportedLocalesSanitized).indexOf(localeCode)) != -1) {
                    acceptLang = supportedLocales[index];
                    return acceptLang;
                }
                if (splitLocale.length <= 1 || (index = Arrays.asList(supportedLocalesSanitized).indexOf(splitLocale[0].toLowerCase())) == -1) continue;
                acceptLang = supportedLocales[index];
                return acceptLang;
            }
            return null;
        }
        return locale;
    }

    public static String[] sanitizeLocaleList(String[] locales) {
        String[] sanitizedLocales = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeCode = locales[i];
            String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
            localeCode = splitLocale[0].toLowerCase();
            if (splitLocale.length > 1) {
                localeCode = localeCode + splitLocale[1].toUpperCase();
            }
            sanitizedLocales[i] = localeCode;
        }
        return sanitizedLocales;
    }

    public static Map<String, Object> getLayoutProperties(Resource elementResource, SlingHttpServletRequest request) throws PersistenceException {
        return GuideUtils.getLayoutProperties(request, elementResource, null);
    }

    public static Map<String, Object> getLayoutProperties(Resource elementResource) throws PersistenceException {
        return GuideUtils.getLayoutProperties(null, elementResource, null);
    }

    public static void putQueryParamsToRedirectRequest(String responseString, Map<String, String> redirectParameters) {
        try {
            String[] pairs = responseString.split("&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length != 2) continue;
                String name = URLDecoder.decode(fields[0].trim(), "UTF-8");
                String value = URLDecoder.decode(fields[1].trim(), "UTF-8");
                redirectParameters.put(name, value);
            }
        }
        catch (Exception e) {
            logger.error("Error while putting params to redirect Request", (Throwable)e);
        }
    }

    public static String getLocaleParamFromRequest(SlingHttpServletRequest request) {
        GuideLocalizationService guideLocalizationService;
        String acceptLangParam = null;
        String[] supportedLocales = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (bindings != null && (guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class)) != null) {
            supportedLocales = guideLocalizationService.getSupportedLocales();
        }
        try {
            acceptLangParam = GuideUtils.getLocaleFromURI(request.getRequestPathInfo(), supportedLocales);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)request.getParameter("afAcceptLang"));
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)((String)request.getAttribute("afAcceptLang")));
            }
            if (GuideUtils.useBrowserLocale(request) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)request.getHeader("Accept-Language"));
            }
        }
        catch (Exception e) {
            logger.error("Could not get locale information in request object: " + e.getMessage(), (Throwable)e);
        }
        return acceptLangParam;
    }

    private static String getLocaleFromURI(RequestPathInfo requestPathInfo, String[] supportedLocales) {
        Object selector = null;
        Object[] selectors = requestPathInfo.getSelectors();
        if (ArrayUtils.isNotEmpty((Object[])selectors) && ArrayUtils.isNotEmpty((Object[])supportedLocales)) {
            for (int i = selectors.length - 1; i >= 0; --i) {
                Object sel = selectors[i];
                if (!ArrayUtils.contains((Object[])supportedLocales, (Object)sel)) continue;
                selector = sel;
                break;
            }
        }
        return selector;
    }

    private static boolean useBrowserLocale(SlingHttpServletRequest request) {
        AdaptiveFormConfigurationService adaptiveFormConfigurationService;
        boolean usePreviousTranslationApproach = false;
        SlingBindings slingBindings = null;
        if (request != null) {
            slingBindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        }
        if (slingBindings != null && (adaptiveFormConfigurationService = (AdaptiveFormConfigurationService)slingBindings.getSling().getService(AdaptiveFormConfigurationService.class)) != null) {
            usePreviousTranslationApproach = adaptiveFormConfigurationService.isUseBrowserLocale();
        }
        return usePreviousTranslationApproach;
    }

    public static String getNamespacedKeys(String value, String key, Resource formResource) {
        String dictKey = "fd_" + value;
        if (formResource != null) {
            dictKey = GuideUtils.getNamespacedKeys(value, key, formResource.getValueMap());
        }
        return dictKey;
    }

    public static String getNamespacedKeys(String value, String key, ValueMap properties) {
        String dictKey = "fd_" + value;
        if (properties != null && !properties.isEmpty() && key != null) {
            try {
                String translationId = TranslationUtils.getTranslationId(properties, key, value);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)translationId)) {
                    dictKey = translationId;
                }
            }
            catch (IOException ex) {
                logger.error("[AF] Unable to fetch translation id for {}", (Object)key, (Object)ex);
            }
        }
        return dictKey;
    }

    public static Resource getPageResource(Resource resource) {
        while (resource != null && !"cq:Page".equals(resource.getResourceType())) {
            resource = resource.getParent();
        }
        return resource;
    }

    public static String getGuideContainerPathFromResource(SlingHttpServletRequest request, Resource resource) {
        String path = null;
        Resource pageResource = GuideUtils.getPageResource(resource);
        Resource guideContainer = GuideUtils.findGuideContainerFromPage(pageResource);
        if (guideContainer != null) {
            path = guideContainer.getPath();
        }
        return path;
    }

    private static Resource findGuideContainerFromPage(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (GuideUtils.isGuideContainerResource(resource)) {
            return resource;
        }
        Resource r = null;
        Iterator t = resource.listChildren();
        while (t.hasNext() && r == null) {
            Resource child = (Resource)t.next();
            if (child != null && GuideUtils.isGuideContainerResource(resource)) {
                return child;
            }
            r = GuideUtils.findGuideContainerFromPage(child);
        }
        return r;
    }

    public static String convertADAssetPathToWebChannelPagePath(String FMDocAssetPath) {
        return GuideUtils.convertFMAssetPathToFormPagePath(FMDocAssetPath) + "/channels/web";
    }

    public static String nodeToString(org.w3c.dom.Node node, Boolean omitXmlDeclaration) {
        String xmlStr = "";
        try {
            if (node != null) {
                TransformerFactory transfac = TransformerFactory.newInstance();
                Transformer trans = transfac.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", omitXmlDeclaration != false ? "yes" : "no");
                trans.setOutputProperty("method", "xml");
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(node);
                trans.transform(source, result);
                xmlStr = sw.toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception while converting document to xml", (Throwable)e);
        }
        return xmlStr;
    }

    public static String getUniqueId() throws GuideException {
        String id;
        try {
            Base32 base32codec = new Base32();
            SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] idBytes = new byte[16];
            securerandom.nextBytes(idBytes);
            id = base32codec.encodeAsString(idBytes).replaceAll("=", "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuideException(e);
        }
        return id;
    }

    public static String getFormRelativePath(String formContainerPath) {
        String formPath = org.apache.commons.lang3.StringUtils.substringBefore((String)formContainerPath, (String)"/jcr:content/guideContainer");
        formPath = org.apache.commons.lang3.StringUtils.replace((String)formPath, (String)"/content/forms/af/", (String)"");
        return formPath;
    }

    private static String getFormRelativePathInSitePage(Resource formContainerResource) {
        FormContainer formContainer = (FormContainer)formContainerResource.adaptTo(FormContainer.class);
        String formPathInSites = formContainer.getParentPagePath();
        formPathInSites = org.apache.commons.lang3.StringUtils.replace((String)formPathInSites, (String)"/content/", (String)"");
        String title = formContainer.getTitle() != null ? formContainer.getTitle() : formContainer.getName();
        formPathInSites = formPathInSites + "/" + title.replaceAll("/", "_");
        return formPathInSites;
    }

    private static String sanitizeFormPath(String formPath) {
        String regex = "[~#%&*:<>^\\[\\]?{\\|}\\s\\\\]";
        return formPath.replaceAll(regex, "_");
    }

    public static Resource getFormResourceFromEncodedPath(String encodedFormPath, ResourceResolver resourceResolver) {
        byte[] bytes = Base64.getDecoder().decode(encodedFormPath);
        Resource resource = resourceResolver.getResource(new String(bytes, StandardCharsets.UTF_8));
        return resource;
    }

    public static Resource getFormContainerResourceFromEncodedPath(String encodedFormPath, ResourceResolver resourceResolver) {
        String formPath;
        byte[] bytes = Base64.getDecoder().decode(encodedFormPath);
        String formContainerPath = formPath = new String(bytes, StandardCharsets.UTF_8);
        Resource formPathResource = resourceResolver.getResource(formPath);
        if (GuideWCMUtils.isForms(formPath) || GuideUtils.isEditableTemplateResource(formPathResource).booleanValue()) {
            formContainerPath = formPath + "/jcr:content/guideContainer";
        }
        return resourceResolver.getResource(formContainerPath);
    }

    public static String sanitizeJSON(String str, XSSAPI xssapi) {
        String sanitizedString = "";
        try {
            JSONObject jsonObject = new JSONObject(str);
            Iterator itr = jsonObject.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                String value = jsonObject.optString(key);
                jsonObject.put(key, (Object)GuideUtils.filterHtml(value, xssapi));
            }
            sanitizedString = jsonObject.toString();
        }
        catch (JSONException ex) {
            sanitizedString = GuideUtils.filterHtml(str, xssapi);
        }
        return sanitizedString;
    }

    public static String getFormDataId(Resource formContainerResource, String submissionId, Date date) {
        Calendar calendar = DateUtils.toCalendar((Date)date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String formContainerResourcePath = formContainerResource.getPath();
        String formPath = GuideWCMUtils.isForms(formContainerResourcePath) ? GuideUtils.getFormRelativePath(formContainerResourcePath) : GuideUtils.getFormRelativePathInSitePage(formContainerResource);
        return GuideUtils.sanitizeFormPath(formPath) + "/" + year + "/" + month + "/" + day + "/" + submissionId;
    }
}

