/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model.value;

import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;

public class CustomDate
extends Date {
    LocalDate localDate;
    ZoneId zoneId;

    CustomDate(LocalDate localDate, ZoneId zoneId, long epochMili) {
        super(epochMili);
        this.localDate = localDate;
        this.zoneId = zoneId;
    }

    public static CustomDate parseInput(String input) {
        try {
            TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_DATE.parse(input);
            return CustomDate.createCustomDate(temporalAccessor);
        }
        catch (Exception e) {
            DermisLogger.logErrorAndDebug(CustomDate.class, "Format type of input date string invalid.Supported format YYYY-MM-DD with optional timezone", "Format type of input date string '" + input + "' invalid.Supported format YYYY-MM-DD with optional timezone");
            return null;
        }
    }

    public static CustomDate convertToCustomDate(Date input) {
        if (input instanceof CustomDate) {
            return (CustomDate)input;
        }
        try {
            Instant instant = input.toInstant();
            TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(instant.toString());
            return CustomDate.createCustomDate(temporalAccessor);
        }
        catch (Exception e) {
            DermisLogger.logErrorAndDebug(CustomDate.class, "Format type of input date invalid.", "Format type of input date '" + input + "' invalid");
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.localDate != null) {
            sb.append(this.localDate.toString());
        }
        if (this.zoneId != null) {
            sb.append(this.zoneId.toString());
        }
        return sb.toString();
    }

    private static CustomDate createCustomDate(TemporalAccessor temporalAccessor) {
        LocalDate localDate = temporalAccessor.query(TemporalQueries.localDate());
        ZoneId zoneId = temporalAccessor.query(TemporalQueries.zone());
        ZoneId instantZoneID = zoneId == null ? ZoneOffset.UTC : zoneId;
        Instant instant = localDate.atStartOfDay(instantZoneID).toInstant();
        return new CustomDate(localDate, zoneId, instant.toEpochMilli());
    }
}

