/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.model.ExtraPropertyType;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum PropertyType {
    STRING("string", String.class),
    NUMBER("number", Double.class),
    INTEGER("integer", Integer.class),
    BOOLEAN("boolean", Boolean.class),
    ARRAY("array", List.class),
    OBJECT("object", Map.class),
    NULL("null", null);

    private static final Map<String, PropertyType> typeMap;
    private final String text;
    private final Class classType;

    private PropertyType(String text, Class classType) {
        this.text = text;
        this.classType = classType;
    }

    public String toString() {
        return this.text;
    }

    public Class getClassType() {
        return this.classType;
    }

    public static PropertyType getPropertyType(Class classType) {
        PropertyType type = null;
        if (classType != null) {
            for (PropertyType propertyType : PropertyType.values()) {
                if (!classType.equals(propertyType.classType)) continue;
                type = propertyType;
                break;
            }
        }
        return type;
    }

    public static PropertyType lookUp(String name) {
        PropertyType result = null;
        if (StringUtils.isBlank((String)name)) {
            throw new NullPointerException("Name is null");
        }
        if (typeMap.containsKey(name.toLowerCase())) {
            result = typeMap.get(name.toLowerCase());
        } else {
            try {
                result = Enum.valueOf(PropertyType.class, name.trim().toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static PropertyType lookUp(PropertyFormatType type) {
        return PropertyType.lookUp(type.toString());
    }

    static {
        typeMap = new HashMap<String, PropertyType>();
        typeMap.put(Type.BINARY.toString(), STRING);
        typeMap.put(Type.BYTE.toString(), STRING);
        typeMap.put(Type.BASE64.toString(), STRING);
        typeMap.put(Type.BASE64BINARY.toString(), STRING);
        typeMap.put(Type.HEXBINARY.toString(), STRING);
        typeMap.put(Type.UNSIGNEDBYTE.toString(), STRING);
        typeMap.put(Type.DATE.toString(), STRING);
        typeMap.put(Type.TIME.toString(), STRING);
        typeMap.put(Type.DATETIME.toString(), STRING);
        typeMap.put(Type.DATE_TIME.toString(), STRING);
        typeMap.put(Type.TOKEN.toString(), STRING);
        typeMap.put(Type.ANYURI.toString(), STRING);
        typeMap.put(ExtraPropertyType.file.name(), STRING);
        typeMap.put(Type.UNSIGNED.toString(), INTEGER);
        typeMap.put(Type.UNSIGNEDINT.toString(), INTEGER);
        typeMap.put(Type.SIGNEDINT.toString(), INTEGER);
        typeMap.put(Type.SHORT.toString(), INTEGER);
        typeMap.put(Type.UNSIGNEDSHORT.toString(), INTEGER);
        typeMap.put(Type.INT.toString(), INTEGER);
        typeMap.put(Type.LONG.toString(), INTEGER);
        typeMap.put(Type.BIGDECIMAL.toString(), INTEGER);
        typeMap.put(Type.FLOAT.toString(), NUMBER);
        typeMap.put(Type.DECIMAL.toString(), NUMBER);
        typeMap.put(Type.DOUBLE.toString(), NUMBER);
        typeMap.put(ExtraPropertyType.collection.name(), ARRAY);
        typeMap.put(ExtraPropertyType.ref.name(), OBJECT);
    }
}

