/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.AbstractAsset;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.Property;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.Relationship;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;

public class DataModel
extends AbstractAsset
implements IDataModel {
    private String schemaName;
    private String id;
    @Named(value="fdm:rootEntity")
    private boolean rootEntity;
    @Named(value="fdm:binaryEntity")
    private boolean binaryEntity;
    @Named(value="fdm:defaultBinaryEntity")
    private boolean defaultBinaryEntity;
    private String[] required;
    private List<IProperty> properties;
    private transient List<Relationship> relationships;
    private boolean genericOperationAllowed;

    public DataModel() {
    }

    public DataModel(String name, String schemaName) {
        super(name);
        this.schemaName = schemaName;
    }

    public DataModel(String name, String schemaName, List<IProperty> properties) {
        this(name, schemaName);
        this.properties = properties;
    }

    public DataModel(String name, String schemaName, List<IProperty> properties, List<Relationship> relationships) {
        this(name, schemaName, properties);
        this.relationships = relationships;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String[] getRequired() {
        return this.required;
    }

    public void setRequired(String[] required) {
        this.required = required;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public List<IProperty> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(List<? extends IProperty> properties) {
        this.properties = properties;
    }

    public void addProperties(List<IProperty> addProperties) {
        if (addProperties != null) {
            if (this.properties == null) {
                this.setProperties(new ArrayList());
            }
            this.properties.addAll(addProperties);
        }
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    public List<Relationship> getRelationships(IDataModel otherDataModel) {
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return this.rootEntity;
    }

    @Override
    public void setRootEntity(boolean value) {
        this.rootEntity = value;
    }

    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    @JsonIgnore
    public String[] getPropertyNames() {
        String[] names = null;
        if (this.getProperties() != null) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (IProperty property : this.getProperties()) {
                nameList.add(property.getName());
            }
            names = nameList.toArray(new String[0]);
        }
        return names;
    }

    public IProperty getPropertyByName(String propertyName) {
        IProperty property = null;
        if (this.getProperties() != null) {
            for (IProperty prop : this.getProperties()) {
                if (prop == null || !prop.getName().equals(propertyName)) continue;
                property = prop;
                break;
            }
        }
        return property;
    }

    @JsonIgnore
    public IProperty[] getPrimaryKeys() {
        IProperty[] buffer = null;
        if (this.getProperties() != null) {
            ArrayList<IProperty> properties = new ArrayList<IProperty>();
            for (IProperty prop : this.getProperties()) {
                if (prop == null || !prop.isPrimaryKey().booleanValue()) continue;
                properties.add(prop);
            }
            buffer = properties.toArray(new IProperty[0]);
        }
        return buffer;
    }

    public void addProperty(IProperty property) {
        if (property != null) {
            List<IProperty> properties = this.getProperties();
            if (properties == null) {
                properties = new ArrayList<IProperty>();
            }
            properties.add(property);
            this.setProperties(properties);
        }
    }

    public void addAssociation(PropertyType associationType, String name, IDataModel dataModel) throws DermisException {
        if (associationType != PropertyType.ARRAY && associationType != PropertyType.OBJECT) {
            throw new DermisException("AEM-FDM-001-004");
        }
        Property property = new Property(name, associationType, null);
        this.addProperty(property);
        property.addAssociation(associationType, dataModel);
    }

    @Override
    public boolean isBinaryEntity() {
        return this.binaryEntity;
    }

    @Override
    public void setBinaryEntity(boolean binaryEntity) {
        this.binaryEntity = binaryEntity;
    }

    @Override
    public boolean isDefaultBinaryEntity() {
        return this.defaultBinaryEntity;
    }

    @Override
    public void setDefaultBinaryEntity(boolean defaultBinaryEntity) {
        this.defaultBinaryEntity = defaultBinaryEntity;
    }

    @Override
    public boolean isGenericOperationAllowed() {
        return this.genericOperationAllowed;
    }

    public void setGenericOperationAllowed(boolean genericOperationAllowed) {
        this.genericOperationAllowed = genericOperationAllowed;
    }
}

