/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.registration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

@Component(componentAbstract=true)
@References(value={@Reference(name="Repository", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=Repository.class)})
public abstract class AbstractRegistrationSupport {
    public static final String REPOSITORY_REGISTRATION_NAME = "name";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private LogService log;
    private ComponentContext componentContext;
    private final Map<String, ServiceReference> repositoryRegistrationBacklog = new HashMap<String, ServiceReference>();
    private final Map<String, Object> registeredRepositories = new HashMap<String, Object>();
    protected final Object registryLock = new Object();

    protected abstract boolean doActivate();

    protected abstract void doDeactivate();

    protected abstract Object bindRepository(String var1, Repository var2);

    protected abstract void unbindRepository(String var1, Object var2);

    protected ComponentContext getComponentContext() {
        return this.componentContext;
    }

    protected void log(int level, String message, Throwable t) {
        LogService log = this.log;
        if (log != null) {
            log.log(level, message, t);
        } else {
            System.err.print(level + " - " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    protected String getName(ServiceReference reference) {
        String name = (String)reference.getProperty(REPOSITORY_REGISTRATION_NAME);
        if (name == null || name.length() == 0) {
            this.log(4, "registerRepository: Repository not to be registered", null);
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        Object object = this.registryLock;
        synchronized (object) {
            this.componentContext = componentContext;
            if (this.doActivate()) {
                Iterator<Map.Entry<String, ServiceReference>> ri = this.repositoryRegistrationBacklog.entrySet().iterator();
                while (ri.hasNext()) {
                    Map.Entry<String, ServiceReference> entry = ri.next();
                    this.bindRepositoryInternal(entry.getKey(), entry.getValue());
                    ri.remove();
                }
            } else {
                String name = (String)componentContext.getProperties().get("component.name");
                this.getComponentContext().disableComponent(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        Object object = this.registryLock;
        synchronized (object) {
            Iterator<Map.Entry<String, Object>> ri = this.registeredRepositories.entrySet().iterator();
            while (ri.hasNext()) {
                Map.Entry<String, Object> entry = ri.next();
                this.unbindRepository(entry.getKey(), entry.getValue());
                ri.remove();
            }
            this.doDeactivate();
            this.componentContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindRepository(ServiceReference reference) {
        String name = this.getName(reference);
        if (name != null) {
            Object object = this.registryLock;
            synchronized (object) {
                if (this.componentContext == null) {
                    this.repositoryRegistrationBacklog.put(name, reference);
                } else {
                    this.bindRepositoryInternal(name, reference);
                }
            }
        } else {
            this.log(3, "Service " + reference.getProperty("service.id") + " has no name property, not registering", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindRepository(ServiceReference reference) {
        String name = this.getName(reference);
        if (name != null) {
            Object object = this.registryLock;
            synchronized (object) {
                Object data = this.registeredRepositories.remove(name);
                if (data != null) {
                    this.unbindRepository(name, data);
                }
                this.repositoryRegistrationBacklog.remove(name);
                if (this.componentContext != null) {
                    this.componentContext.getBundleContext().ungetService(reference);
                }
            }
        } else {
            this.log(4, "Service " + reference.getProperty("service.id") + " has no name property, nothing to unregister", null);
        }
    }

    protected void bindLog(LogService log) {
        this.log = log;
    }

    protected void unbindLog(LogService log) {
        this.log = null;
    }

    private void bindRepositoryInternal(String name, ServiceReference reference) {
        Repository repository = (Repository)this.getComponentContext().getBundleContext().getService(reference);
        Object data = this.bindRepository(name, repository);
        if (data != null) {
            this.registeredRepositories.put(name, data);
        }
    }
}

