/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import aQute.bnd.annotation.ProviderType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.Workspace;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractNamespaceMappingRepository;
import org.apache.sling.jcr.base.util.RepositoryAccessor;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@ProviderType
@Component(componentAbstract=true)
public abstract class AbstractSlingRepository
extends AbstractNamespaceMappingRepository
implements SlingRepository,
Runnable {
    public static final String DEFAULT_ANONYMOUS_USER = "anonymous";
    public static final String DEFAULT_ANONYMOUS_PASS = "anonymous";
    public static final String DEFAULT_ADMIN_USER = "admin";
    public static final String DEFAULT_ADMIN_PASS = "admin";
    public static final boolean DEFAULT_LOGIN_ADMIN_ENABLED = true;
    @Property
    public static final String PROPERTY_DEFAULT_WORKSPACE = "defaultWorkspace";
    @Property(value={"anonymous"})
    public static final String PROPERTY_ANONYMOUS_USER = "anonymous.name";
    @Property(value={"anonymous"})
    public static final String PROPERTY_ANONYMOUS_PASS = "anonymous.password";
    @Property(value={"admin"})
    public static final String PROPERTY_ADMIN_USER = "admin.name";
    @Property(value={"admin"})
    public static final String PROPERTY_ADMIN_PASS = "admin.password";
    @Property(boolValue={true})
    public static final String PROPERTY_LOGIN_ADMIN_ENABLED = "admin.login.enabled";
    public static final int DEFAULT_POLL_ACTIVE = 10;
    public static final int DEFAULT_POLL_INACTIVE = 10;
    @Property(intValue={10})
    public static final String PROPERTY_POLL_ACTIVE = "poll.active";
    @Property(intValue={10})
    public static final String PROPERTY_POLL_INACTIVE = "poll.inactive";
    public static final int MIN_POLL = 2;
    @Reference
    private LogService log;
    @Reference
    private ServiceUserMapper serviceUserMapper;
    private ComponentContext componentContext;
    private Repository repository;
    private ServiceRegistration repositoryService;
    private String defaultWorkspace;
    private String anonUser;
    private char[] anonPass;
    private String adminUser;
    private char[] adminPass;
    private boolean disableLoginAdministrative;
    private long pollTimeInActiveSeconds;
    private long pollTimeActiveSeconds;
    private boolean running;
    private Thread repositoryPinger;

    protected AbstractSlingRepository() {
    }

    @Override
    public final String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    private void setDefaultWorkspace(String defaultWorkspace) {
        if (defaultWorkspace != null && (defaultWorkspace = defaultWorkspace.trim()).length() == 0) {
            defaultWorkspace = null;
        }
        this.log(4, "setDefaultWorkspace: Setting the default workspace to " + defaultWorkspace);
        this.defaultWorkspace = defaultWorkspace;
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    @Override
    public final Session loginAdministrative(String workspace) throws RepositoryException {
        if (this.disableLoginAdministrative) {
            this.log(1, "SlingRepository.loginAdministrative is disabled. Please use SlingRepository.loginService.");
            throw new LoginException();
        }
        this.log(2, "SlingRepository.loginAdministrative is deprecated. Please use SlingRepository.loginService.");
        return this.loginAdministrativeInternal(workspace);
    }

    @Override
    public final Session loginService(String subServiceName, String workspace) throws LoginException, RepositoryException {
        this.log(1, "loginService: Cannot get using Bundle because this SlingRepository service is not a ServiceFactory");
        throw new LoginException();
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspace);
    }

    public Session login(Credentials credentials, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.componentContext == null || this.getRepository() == null) {
            throw new RepositoryException("Sling Repository not ready");
        }
        if (credentials == null) {
            credentials = this.getAnonCredentials(this.anonUser);
        }
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        try {
            this.log(4, "login: Logging in to workspace '" + workspace + "'");
            Session session = this.getRepository().login(credentials, workspace);
            if (workspace == null) {
                String defaultWorkspace = session.getWorkspace().getName();
                this.log(4, "login: Using " + defaultWorkspace + " as the default workspace instead of 'null'");
                this.setDefaultWorkspace(defaultWorkspace);
            }
            return this.getNamespaceAwareSession(session);
        }
        catch (NoSuchWorkspaceException nswe) {
            if (workspace != null && workspace.equals(this.getDefaultWorkspace()) && this.createWorkspace(workspace)) {
                return this.getRepository().login(credentials, workspace);
            }
            throw nswe;
        }
        catch (RuntimeException re) {
            throw new RepositoryException(re.getMessage(), (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Session loginService(Bundle usingBundle, String subServiceName, String workspace) throws LoginException, RepositoryException {
        String userName = this.serviceUserMapper.getServiceUserID(usingBundle, subServiceName);
        if (userName == null) {
            throw new LoginException("Cannot derive user name for bundle " + usingBundle + " and sub service " + subServiceName);
        }
        SimpleCredentials creds = new SimpleCredentials(userName, new char[0]);
        Session admin = null;
        try {
            admin = this.loginAdministrativeInternal(workspace);
            Session session = admin.impersonate((Credentials)creds);
            return session;
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    protected Session loginAdministrativeInternal(String workspace) throws RepositoryException {
        Credentials sc = this.getAdministrativeCredentials(this.adminUser);
        return this.login(sc, workspace);
    }

    protected Credentials getAnonCredentials(String anonUser) {
        return new SimpleCredentials(anonUser, this.anonPass);
    }

    protected Credentials getAdministrativeCredentials(String adminUser) {
        return new SimpleCredentials(adminUser, this.adminPass);
    }

    public String getDescriptor(String name) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptor(name);
        }
        this.log(1, "getDescriptor: Repository not available");
        return null;
    }

    public String[] getDescriptorKeys() {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorKeys();
        }
        this.log(1, "getDescriptorKeys: Repository not available");
        return new String[0];
    }

    public Value getDescriptorValue(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValue(key);
        }
        this.log(1, "getDescriptorValue: Repository not available");
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValues(key);
        }
        this.log(1, "getDescriptorValues: Repository not available");
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isSingleValueDescriptor(key);
        }
        this.log(1, "isSingleValueDescriptor: Repository not available");
        return false;
    }

    public boolean isStandardDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isStandardDescriptor(key);
        }
        this.log(1, "isStandardDescriptor: Repository not available");
        return false;
    }

    protected void log(int level, String message) {
        this.log(level, message, null);
    }

    protected void log(int level, String message, Throwable t) {
        LogService log = this.log;
        if (log != null) {
            if (this.componentContext != null) {
                log.log(this.componentContext.getServiceReference(), level, message, t);
            } else {
                log.log(level, message, t);
            }
        }
    }

    protected RepositoryAccessor getRepositoryAccessor() {
        return new RepositoryAccessor();
    }

    protected Repository acquireRepository() {
        String overrideUrl = (String)this.componentContext.getProperties().get("sling.repository.url");
        if (overrideUrl == null) {
            overrideUrl = this.componentContext.getBundleContext().getProperty("sling.repository.url");
        }
        if (overrideUrl != null && overrideUrl.length() > 0) {
            this.log(3, "acquireRepository: Will not use embedded repository due to property sling.repository.url=" + overrideUrl + ", acquiring repository using that URL");
            return this.getRepositoryAccessor().getRepositoryFromURL(overrideUrl);
        }
        this.log(4, "acquireRepository: No existing repository to access");
        return null;
    }

    protected void setupRepository(Repository repository) {
        this.setup(this.componentContext.getBundleContext());
    }

    protected final ServiceRegistration registerService() {
        Dictionary<String, Object> props = this.getServiceRegistrationProperties();
        final String[] interfaces = this.getServiceRegistrationInterfaces();
        return this.componentContext.getBundleContext().registerService(interfaces, (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return SlingRepositoryProxyHandler.createProxy(interfaces, AbstractSlingRepository.this, bundle);
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, props);
    }

    protected Dictionary<String, Object> getServiceRegistrationProperties() {
        return this.componentContext.getProperties();
    }

    protected String[] getServiceRegistrationInterfaces() {
        return new String[]{SlingRepository.class.getName(), Repository.class.getName()};
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected boolean pingRepository(Repository repository) {
        if (repository != null) {
            try {
                return repository.getDescriptor("jcr.specification.name") != null;
            }
            catch (Throwable t) {
                this.log(4, "pingRepository: Repository " + repository + " does not seem to be available any more", t);
            }
        }
        return false;
    }

    protected boolean pingAndCheck() {
        if (this.repository == null) {
            throw new IllegalStateException("Repository is null");
        }
        boolean result = false;
        if (this.pingRepository(this.repository)) {
            try {
                Session s = this.loginAdministrativeInternal(this.getDefaultWorkspace());
                s.logout();
                result = true;
            }
            catch (RepositoryException re) {
                this.log.log(3, "pingAndCheck; loginAdministrative failed", (Throwable)re);
            }
        }
        return result;
    }

    protected void unregisterService(ServiceRegistration serviceRegistration) {
        serviceRegistration.unregister();
    }

    protected void tearDown(Repository repository) {
        this.tearDown();
    }

    protected void disposeRepository(Repository repository) {
    }

    protected ComponentContext getComponentContext() {
        return this.componentContext;
    }

    protected void activate(ComponentContext componentContext) throws Exception {
        this.componentContext = componentContext;
        Dictionary properties = componentContext.getProperties();
        this.setDefaultWorkspace(this.getProperty((Dictionary<String, Object>)properties, PROPERTY_DEFAULT_WORKSPACE, null));
        this.anonUser = this.getProperty((Dictionary<String, Object>)properties, PROPERTY_ANONYMOUS_USER, "anonymous");
        this.anonPass = this.getProperty((Dictionary<String, Object>)properties, PROPERTY_ANONYMOUS_PASS, "anonymous").toCharArray();
        this.adminUser = this.getProperty((Dictionary<String, Object>)properties, PROPERTY_ADMIN_USER, "admin");
        this.adminPass = this.getProperty((Dictionary<String, Object>)properties, PROPERTY_ADMIN_PASS, "admin").toCharArray();
        this.disableLoginAdministrative = !this.getProperty((Dictionary<String, Object>)properties, PROPERTY_LOGIN_ADMIN_ENABLED, true);
        this.setPollTimeActive(this.getIntProperty(properties, PROPERTY_POLL_ACTIVE));
        this.setPollTimeInActive(this.getIntProperty(properties, PROPERTY_POLL_INACTIVE));
        try {
            if (this.startRepository()) {
                this.log(3, "Repository started successfully");
            } else {
                this.log(2, "Repository startup failed, will try later");
            }
        }
        catch (Throwable t) {
            this.log(2, "activate: Unexpected problem starting repository", t);
        }
        this.startRepositoryPinger();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.stopRepositoryPinger();
        if (this.repository != null || this.repositoryService != null) {
            this.log(3, "deactivate: Repository still running, forcing shutdown");
            try {
                this.stopRepository();
            }
            catch (Throwable t) {
                this.log(2, "deactivate: Unexpected problem stopping repository", t);
            }
        }
        this.componentContext = null;
    }

    protected void bindLog(LogService log) {
        this.log = log;
    }

    protected void unbindLog(LogService log) {
        if (this.log == log) {
            this.log = null;
        }
    }

    private String getProperty(Dictionary<String, Object> properties, String name, String defaultValue) {
        Object prop = properties.get(name);
        return prop instanceof String ? (String)prop : defaultValue;
    }

    private int getIntProperty(Dictionary<String, Object> properties, String name) {
        Object prop = properties.get(name);
        if (prop instanceof Number) {
            return ((Number)prop).intValue();
        }
        if (prop != null) {
            try {
                return Integer.decode(String.valueOf(prop));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean getProperty(Dictionary<String, Object> properties, String name, boolean defaultValue) {
        Object prop = properties.get(name);
        if (prop instanceof Boolean) {
            return (Boolean)prop;
        }
        if (prop instanceof String) {
            return Boolean.valueOf((String)prop);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createWorkspace(String workspace) {
        this.log(3, "createWorkspace: Requested workspace " + workspace + " does not exist, trying to create");
        Session tmpSession = null;
        try {
            Credentials sc = this.getAdministrativeCredentials(this.adminUser);
            tmpSession = this.getRepository().login(sc);
            Workspace defaultWs = tmpSession.getWorkspace();
            defaultWs.createWorkspace(workspace);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.log(1, "createWorkspace: Cannot create requested workspace " + workspace, t);
        }
        finally {
            if (tmpSession != null) {
                tmpSession.logout();
            }
        }
        return false;
    }

    private void setPollTimeActive(int seconds) {
        if (seconds < 2) {
            seconds = 10;
        }
        this.pollTimeActiveSeconds = seconds;
    }

    private void setPollTimeInActive(int seconds) {
        if (seconds < 2) {
            seconds = 10;
        }
        this.pollTimeInActiveSeconds = seconds;
    }

    private void startRepositoryPinger() {
        if (this.repositoryPinger == null) {
            this.running = true;
            this.repositoryPinger = new Thread((Runnable)this, "Repository Pinger");
            this.repositoryPinger.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRepositoryPinger() {
        this.running = false;
        Thread rpThread = this.repositoryPinger;
        if (rpThread == null) {
            return;
        }
        this.repositoryPinger = null;
        Thread thread = rpThread;
        synchronized (thread) {
            rpThread.notifyAll();
        }
        try {
            rpThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (rpThread.isAlive()) {
            this.log(1, "stopRepositoryPinger: Timed waiting for thread " + rpThread + " to terminate");
        }
    }

    private boolean startRepository() {
        try {
            this.log(4, "startRepository: calling acquireRepository()");
            Repository newRepo = this.acquireRepository();
            if (newRepo != null) {
                this.log(4, "startRepository: got a Repository, calling pingRepository()");
                if (this.pingRepository(newRepo)) {
                    this.repository = newRepo;
                    if (this.pingAndCheck()) {
                        this.log(4, "startRepository: pingRepository() and pingAndCheck() successful, calling setupRepository()");
                        this.setupRepository(newRepo);
                        this.log(4, "startRepository: calling registerService()");
                        this.repositoryService = this.registerService();
                        this.log(4, "registerService() successful, registration=" + this.repositoryService);
                        return true;
                    }
                    this.log(4, "pingRepository() successful but pingAndCheck() fails, calling disposeRepository()");
                    this.repository = null;
                } else {
                    this.log(4, "startRepository: pingRepository() failed, calling disposeRepository()");
                }
                this.disposeRepository(newRepo);
            }
        }
        catch (Throwable t) {
            this.log(1, "startRepository: Uncaught Throwable trying to access Repository, calling stopRepository()", t);
            this.stopRepository();
        }
        return false;
    }

    private void stopRepository() {
        if (this.repositoryService != null) {
            try {
                this.log(4, "Unregistering SlingRepository service, registration=" + this.repositoryService);
                this.unregisterService(this.repositoryService);
            }
            catch (Throwable t) {
                this.log(3, "stopRepository: Uncaught problem unregistering the repository service", t);
            }
            this.repositoryService = null;
        }
        if (this.repository != null) {
            Repository oldRepo = this.repository;
            this.repository = null;
            try {
                this.tearDown(oldRepo);
            }
            catch (Throwable t) {
                this.log(3, "stopRepository: Uncaught problem tearing down the repository", t);
            }
            try {
                this.disposeRepository(oldRepo);
            }
            catch (Throwable t) {
                this.log(3, "stopRepository: Uncaught problem disposing the repository", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long pollTimeMsec = 100L;
        long MSEC = 1000L;
        int pollTimeFactor = 2;
        Thread waitLock = this.repositoryPinger;
        try {
            while (this.running) {
                Thread thread = waitLock;
                synchronized (thread) {
                    try {
                        waitLock.wait(pollTimeMsec);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                long newPollTime = pollTimeMsec;
                if (!this.running) continue;
                Repository repo = this.repository;
                boolean ok = false;
                if (repo == null) {
                    if (this.startRepository()) {
                        this.log(3, "Repository started successfully");
                        ok = true;
                        newPollTime = this.pollTimeActiveSeconds * 1000L;
                    } else {
                        newPollTime = Math.min(pollTimeMsec * 2L, Math.max(this.pollTimeInActiveSeconds, this.pollTimeActiveSeconds) * 1000L);
                    }
                } else if (this.pingAndCheck()) {
                    ok = true;
                    newPollTime = this.pollTimeActiveSeconds * 1000L;
                } else {
                    this.log(3, "run: Repository not accessible anymore, unregistering service");
                    this.stopRepository();
                    newPollTime = this.pollTimeInActiveSeconds * 1000L;
                }
                if (newPollTime == pollTimeMsec) continue;
                pollTimeMsec = newPollTime;
                this.log(4, "Repository Pinger interval set to " + pollTimeMsec + " msec, repository is " + (ok ? "available" : "NOT available"));
            }
            this.log(3, "Repository Pinger stopping on request");
        }
        catch (Throwable t) {
            this.log(1, "Repository Pinger caught unexpected issue", t);
        }
        finally {
            this.log(3, "Stopping repository on shutdown");
            this.stopRepository();
        }
    }

    protected void bindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        this.serviceUserMapper = serviceUserMapper;
    }

    protected void unbindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        if (this.serviceUserMapper == serviceUserMapper) {
            this.serviceUserMapper = null;
        }
    }

    private static class SlingRepositoryProxyHandler
    implements InvocationHandler {
        private static final String LOGIN_SERVICE_NAME = "loginService";
        private final AbstractSlingRepository delegatee;
        private final Bundle usingBundle;

        static Object createProxy(String[] interfaceNames, AbstractSlingRepository delegatee, Bundle usingBundle) {
            ClassLoader cl = delegatee.getClass().getClassLoader();
            Class[] interfaces = new Class[interfaceNames.length];
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    interfaces[i] = cl.loadClass(interfaceNames[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LoggerFactory.getLogger(SlingRepositoryProxyHandler.class).error("createProxy: Cannot load interface class " + interfaceNames[i], (Throwable)e);
                    return null;
                }
            }
            SlingRepositoryProxyHandler handler = new SlingRepositoryProxyHandler(delegatee, usingBundle);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)handler);
        }

        private SlingRepositoryProxyHandler(AbstractSlingRepository delegatee, Bundle usingBundle) {
            this.delegatee = delegatee;
            this.usingBundle = usingBundle;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOGIN_SERVICE_NAME.equals(method.getName()) && args != null && args.length == 2) {
                return this.delegatee.loginService(this.usingBundle, (String)args[0], (String)args[1]);
            }
            try {
                return method.invoke((Object)this.delegatee, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }
}

