/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.api.tasks;

import java.util.Map;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeStateTask
extends InstallTask {
    private static final String ORDER = "00-";
    private final ResourceState state;
    private final String[] removeAttributes;
    private final Map<String, Object> addAttributes;

    public ChangeStateTask(TaskResourceGroup r, ResourceState s) {
        this(r, s, null, null);
    }

    public ChangeStateTask(TaskResourceGroup r, ResourceState s, Map<String, Object> addAttributes, String[] removeAttributes) {
        super(r);
        this.state = s;
        this.addAttributes = addAttributes;
        this.removeAttributes = removeAttributes;
    }

    @Override
    public void execute(InstallationContext ctx) {
        TaskResource resource = this.getResource();
        if (resource != null) {
            if (this.removeAttributes != null) {
                for (String name : this.removeAttributes) {
                    resource.setAttribute(name, null);
                }
            }
            if (this.addAttributes != null) {
                for (Map.Entry<String, Object> entry : this.addAttributes.entrySet()) {
                    resource.setAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
        this.setFinishedState(this.state);
    }

    @Override
    public String getSortKey() {
        return ORDER + this.getResource().getEntityId();
    }
}

