/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.ServiceReference;

public class HealthCheckMetadata {
    private final String name;
    private final String mbeanName;
    private final String title;
    private final long serviceId;
    private final List<String> tags;
    private final transient ServiceReference serviceReference;

    public HealthCheckMetadata(ServiceReference ref) {
        this.serviceId = (Long)ref.getProperty("service.id");
        this.name = (String)ref.getProperty("hc.name");
        this.mbeanName = (String)ref.getProperty("hc.mbean.name");
        this.title = this.getHealthCheckTitle(ref);
        this.tags = this.arrayPropertyToListOfStr(ref.getProperty("hc.tags"));
        this.serviceReference = ref;
    }

    public String getName() {
        return this.name;
    }

    public String getMBeanName() {
        return this.mbeanName;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.serviceId ^ this.serviceId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HealthCheckMetadata)) {
            return false;
        }
        HealthCheckMetadata other = (HealthCheckMetadata)obj;
        return this.serviceId == other.serviceId;
    }

    public String toString() {
        return "HealthCheck '" + this.name + "'";
    }

    private String getHealthCheckTitle(ServiceReference ref) {
        String name = (String)ref.getProperty("hc.name");
        if (StringUtils.isBlank((String)name)) {
            name = (String)ref.getProperty("service.description");
        }
        if (StringUtils.isBlank((String)name)) {
            name = (String)ref.getProperty("service.pid");
        }
        if (StringUtils.isBlank((String)name)) {
            name = "HealthCheck:" + ref.getProperty("service.id");
        }
        return name;
    }

    private List<String> arrayPropertyToListOfStr(Object arrayProp) {
        LinkedList<String> res = new LinkedList<String>();
        if (arrayProp instanceof String) {
            res.add((String)arrayProp);
        } else if (arrayProp instanceof String[]) {
            res.addAll(Arrays.asList((String[])arrayProp));
        }
        return res;
    }
}

