/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.auth.spi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.auth.spi.AuthenticationFeedbackHandler;
import org.apache.sling.commons.auth.spi.AuthenticationInfo;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationFeedbackHandler
implements AuthenticationFeedbackHandler {
    public static boolean handleRedirect(HttpServletRequest request, HttpServletResponse response) {
        String redirect = request.getParameter("sling.auth.redirect");
        if (redirect != null) {
            String target = "true".equalsIgnoreCase(redirect) || redirect.length() == 0 ? request.getRequestURI() : (redirect.startsWith("/") ? request.getContextPath() + redirect : redirect);
            try {
                response.sendRedirect(target);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DefaultAuthenticationFeedbackHandler.class).error("handleRedirect: Failed to send redirect to " + target + ", aborting request without redirect", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        return DefaultAuthenticationFeedbackHandler.handleRedirect(request, response);
    }
}

