/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.spi;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationInfo
extends HashMap<String, Object> {
    public static final AuthenticationInfo DOING_AUTH = new ReadOnlyAuthenticationInfo("DOING_AUTH");
    public static final AuthenticationInfo FAIL_AUTH = new ReadOnlyAuthenticationInfo("FAIL_AUTH");
    public static final String AUTH_TYPE = "sling.authType";

    public AuthenticationInfo(String authType) {
        this(authType, null, null);
    }

    public AuthenticationInfo(String authType, String userId) {
        this(authType, userId, null);
    }

    public AuthenticationInfo(String authType, String userId, char[] password) {
        super.put(AUTH_TYPE, authType);
        this.putIfNotNull("user.name", userId);
        this.putIfNotNull("user.password", password);
    }

    public final void setAuthType(String authType) {
        this.putIfNotNull(AUTH_TYPE, authType);
    }

    public final String getAuthType() {
        return (String)this.get(AUTH_TYPE);
    }

    public final void setUser(String user) {
        this.putIfNotNull("user.name", user);
    }

    public final String getUser() {
        return (String)this.get("user.name");
    }

    public final void setPassword(char[] password) {
        this.putIfNotNull("user.password", password);
    }

    public final char[] getPassword() {
        return (char[])this.get("user.password");
    }

    @Override
    public Object put(String key, Object value) {
        if (AUTH_TYPE.equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("sling.authType property must be a String");
        }
        if ("user.name".equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("user.name property must be a String");
        }
        if ("user.password".equals(key) && !(value instanceof char[])) {
            throw new IllegalArgumentException("user.password property must be a char[]");
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (AUTH_TYPE.equals(key)) {
            return null;
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        String authType = this.getAuthType();
        super.clear();
        this.setAuthType(authType);
    }

    private void putIfNotNull(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnlyAuthenticationInfo
    extends AuthenticationInfo {
        ReadOnlyAuthenticationInfo(String authType) {
            super(authType);
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Object remove(Object key) {
            return null;
        }
    }
}

