/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request;

import java.io.IOException;
import java.io.Writer;

public class ResponseUtil {
    public static String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static Writer getXmlEscapingWriter(Writer target) {
        return new XmlEscapingWriter(target);
    }

    private static class XmlEscapingWriter
    extends Writer {
        private final Writer target;

        XmlEscapingWriter(Writer target) {
            this.target = target;
        }

        public void close() throws IOException {
            this.target.close();
        }

        public void flush() throws IOException {
            this.target.flush();
        }

        public void write(char[] buffer, int offset, int length) throws IOException {
            for (int i = offset; i < offset + length; ++i) {
                this.write(buffer[i]);
            }
        }

        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        public void write(int c) throws IOException {
            if (c == 38) {
                this.target.write("&amp;");
            } else if (c == 60) {
                this.target.write("&lt;");
            } else if (c == 62) {
                this.target.write("&gt;");
            } else if (c == 34) {
                this.target.write("&quot;");
            } else if (c == 39) {
                this.target.write("&apos;");
            } else {
                this.target.write(c);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }

        public void write(String str) throws IOException {
            this.write(str.toCharArray());
        }
    }
}

