/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.RepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryProvider {
    protected static Logger log = LoggerFactory.getLogger(RepositoryProvider.class);
    private Map<RepositoryAddress, Repository> repos = new HashMap<RepositoryAddress, Repository>();

    public Repository getRepository(RepositoryAddress address) throws RepositoryException {
        Repository rep = this.repos.get(address);
        if (rep == null) {
            rep = this.createRepository(address);
            this.repos.put(address, rep);
        }
        return rep;
    }

    private Repository createRepository(RepositoryAddress address) throws RepositoryException {
        Iterator<RepositoryFactory> iter = ServiceRegistry.lookupProviders(RepositoryFactory.class);
        HashSet<String> supported = new HashSet<String>();
        while (iter.hasNext()) {
            Repository wrapped;
            RepositoryFactory fac = iter.next();
            supported.addAll(fac.getSupportedSchemes());
            Repository rep = fac.createRepository(address);
            if (rep == null) continue;
            if ((Boolean.getBoolean("jcrlog.sysout") || System.getProperty("jcrlog.file") != null) && (wrapped = this.wrapLogger(rep, address)) != null) {
                log.info("Enabling JCR Logger.");
                rep = wrapped;
            }
            return rep;
        }
        StringBuffer msg = new StringBuffer("URL scheme ");
        msg.append(address.getURI().getScheme());
        msg.append(" not supported. only");
        for (String s : supported) {
            msg.append(" ").append(s);
        }
        throw new RepositoryException(msg.toString());
    }

    private Repository wrapLogger(Repository base, RepositoryAddress address) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.apache.jackrabbit.jcrlog.RepositoryLogger");
            Properties props = new Properties();
            for (Object o : System.getProperties().keySet()) {
                String name = o.toString();
                if (!name.startsWith("jcrlog.")) continue;
                props.put(name.substring("jcrlog.".length()), System.getProperty(name));
            }
            Constructor<?> c = clazz.getConstructor(Repository.class, Properties.class, String.class);
            return (Repository)c.newInstance(base, props, address.toString());
        }
        catch (Exception e) {
            log.error("Unable to initialize JCR logger: {}", (Object)e.toString());
            return null;
        }
    }
}

