/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeTypeSet
implements NodeTypeSet {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeTypeSet.class);
    private String systemId;
    private Map<Name, QNodeTypeDefinition> nodeTypes = new TreeMap<Name, QNodeTypeDefinition>();
    private NamespaceMapping nsMapping = new NamespaceMapping();
    private Map<Name, QNodeTypeDefinition> removed = new TreeMap<Name, QNodeTypeDefinition>();

    public DefaultNodeTypeSet(String systemId) {
        this.systemId = systemId;
    }

    public DefaultNodeTypeSet(NodeTypeSet set) {
        this(set.getSystemId(), set.getNodeTypes().values(), set.getNamespaceMapping());
    }

    public DefaultNodeTypeSet(String systemId, Collection<QNodeTypeDefinition> nodeTypes, NamespaceMapping nsMapping) {
        this.systemId = systemId;
        for (QNodeTypeDefinition t : nodeTypes) {
            this.nodeTypes.put(t.getName(), t);
        }
        this.nsMapping = nsMapping;
    }

    public void add(NodeTypeSet set) {
        for (QNodeTypeDefinition tpl : set.getNodeTypes().values()) {
            log.debug("adding {}", (Object)tpl.getName());
            this.nodeTypes.put(tpl.getName(), tpl);
        }
        this.add(set.getNamespaceMapping());
    }

    public void add(Collection<QNodeTypeDefinition> set, NamespaceMapping nsMapping) {
        for (QNodeTypeDefinition tpl : set) {
            log.debug("adding {}", (Object)tpl.getName());
            this.nodeTypes.put(tpl.getName(), tpl);
        }
        this.add(nsMapping);
    }

    private void add(NamespaceMapping mapping) {
        for (String o : mapping.getPrefixToURIMapping().keySet()) {
            try {
                String pfx = o;
                String uri = mapping.getURI(pfx);
                this.nsMapping.setMapping(pfx, uri);
            }
            catch (NamespaceException e) {
                throw new IllegalStateException("Error while transfering mappings.", e);
            }
        }
    }

    public QNodeTypeDefinition remove(Name name) throws RepositoryException {
        QNodeTypeDefinition tpl = this.nodeTypes.remove(name);
        if (tpl != null) {
            this.removed.put(tpl.getName(), tpl);
            log.debug("removing registered {}", (Object)tpl.getName());
        }
        return tpl;
    }

    @Override
    public Map<Name, QNodeTypeDefinition> getNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public NamespaceMapping getNamespaceMapping() {
        return this.nsMapping;
    }

    public Map<Name, QNodeTypeDefinition> getRemoved() {
        return this.removed;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

