/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import javax.jcr.Credentials;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.SimpleCredentialsConfig;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class CredentialsConfig {
    public final String type;
    public static final String ATTR_TYPE = "type";
    public static final String ELEM_CREDETIALS = "credentials";

    public CredentialsConfig(String type) {
        this.type = type;
    }

    public static CredentialsConfig load(Element elem) throws ConfigurationException {
        assert (elem.getNodeName().equals(ELEM_CREDETIALS));
        String type = elem.getAttribute(ATTR_TYPE);
        if (type == null || type.equals("simple")) {
            return SimpleCredentialsConfig.load(elem);
        }
        throw new ConfigurationException("unknown credentials type: " + type);
    }

    public abstract Credentials getCredentials();

    public void write(ContentHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", ATTR_TYPE, "", "CDATA", this.type);
        handler.startElement("", ELEM_CREDETIALS, "", attrs);
        this.writeInner(handler);
        handler.endElement("", ELEM_CREDETIALS, "");
    }

    protected abstract void writeInner(ContentHandler var1) throws SAXException;
}

