/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.util;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;

public final class UserUtil
implements UserConstants {
    private UserUtil() {
    }

    @Nonnull
    public static String getAdminId(@Nonnull ConfigurationParameters parameters) {
        return parameters.getConfigValue("adminId", "admin");
    }

    @Nonnull
    public static String getAnonymousId(@Nonnull ConfigurationParameters parameters) {
        return parameters.getConfigValue("anonymousId", "anonymous");
    }

    public static boolean isType(@Nullable Tree authorizableTree, @Nonnull AuthorizableType type) {
        if (authorizableTree != null) {
            String ntName = TreeUtil.getPrimaryTypeName(authorizableTree);
            switch (type) {
                case GROUP: {
                    return "rep:Group".equals(ntName);
                }
                case USER: {
                    return "rep:User".equals(ntName);
                }
            }
            return "rep:User".equals(ntName) || "rep:Group".equals(ntName);
        }
        return false;
    }

    @CheckForNull
    public static AuthorizableType getType(@Nonnull Tree authorizableNode) {
        String ntName = TreeUtil.getPrimaryTypeName(authorizableNode);
        if (ntName != null) {
            if ("rep:Group".equals(ntName)) {
                return AuthorizableType.GROUP;
            }
            if ("rep:User".equals(ntName)) {
                return AuthorizableType.USER;
            }
        }
        return null;
    }

    @CheckForNull
    public static String getAuthorizableRootPath(ConfigurationParameters parameters, AuthorizableType type) {
        String path = null;
        if (type != null) {
            switch (type) {
                case USER: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    break;
                }
                case GROUP: {
                    path = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    break;
                }
                default: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    String groupRoot = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    while (!Text.isDescendant(path, groupRoot)) {
                        path = Text.getRelativeParent(path, 1);
                    }
                    break block0;
                }
            }
        }
        return path;
    }

    @CheckForNull
    public static String getAuthorizableId(@Nonnull Tree authorizableTree) {
        Preconditions.checkNotNull((Object)authorizableTree);
        if (UserUtil.isType(authorizableTree, AuthorizableType.AUTHORIZABLE)) {
            PropertyState idProp = authorizableTree.getProperty("rep:authorizableId");
            if (idProp != null) {
                return idProp.getValue(Type.STRING);
            }
            return Text.unescapeIllegalJcrChars(authorizableTree.getName());
        }
        return null;
    }
}

