/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Queues;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.index.IndexRowImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cursors {
    private Cursors() {
    }

    public static Cursor newIntersectionCursor(Cursor a, Cursor b, QueryEngineSettings settings) {
        return new IntersectionCursor(a, b, settings);
    }

    public static Cursor newConcatCursor(List<Cursor> cursors, QueryEngineSettings settings) {
        return new ConcatCursor(cursors, settings);
    }

    public static Cursor newPathCursor(Iterable<String> paths, QueryEngineSettings settings) {
        return new PathCursor(paths.iterator(), true, settings);
    }

    public static Cursor newPathCursorDistinct(Iterable<String> paths, QueryEngineSettings settings) {
        return new PathCursor(paths.iterator(), true, settings);
    }

    public static Cursor newTraversingCursor(Filter filter, NodeState rootState) {
        return new TraversingCursor(filter, rootState);
    }

    public static Cursor newAncestorCursor(Cursor c, int level, QueryEngineSettings settings) {
        Preconditions.checkNotNull((Object)c);
        Preconditions.checkArgument((level >= 1 ? 1 : 0) != 0);
        return new AncestorCursor(c, level, settings);
    }

    private static class ConcatCursor
    extends AbstractCursor {
        private final HashSet<String> seen = new HashSet();
        private final List<Cursor> cursors;
        private final QueryEngineSettings settings;
        private boolean init;
        private boolean closed;
        private Cursor currentCursor;
        private IndexRow current;

        ConcatCursor(List<Cursor> cursors, QueryEngineSettings settings) {
            this.cursors = cursors;
            this.settings = settings;
            this.currentCursor = cursors.remove(0);
        }

        @Override
        public IndexRow next() {
            if (this.closed) {
                throw new IllegalStateException("This cursor is closed");
            }
            if (!this.init) {
                this.fetchNext();
                this.init = true;
            }
            IndexRow result = this.current;
            this.fetchNext();
            return result;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        private void fetchNext() {
            String p;
            IndexRow c;
            while (true) {
                if (!this.currentCursor.hasNext()) {
                    if (this.cursors.isEmpty()) {
                        this.closed = true;
                        return;
                    }
                    this.currentCursor = this.cursors.remove(0);
                    continue;
                }
                c = this.currentCursor.next();
                p = c.getPath();
                if (!this.seen.contains(p)) break;
            }
            this.current = c;
            this.markSeen(p);
        }

        private void markSeen(String path) {
            this.seen.add(path);
            FilterIterators.checkMemoryLimit(this.seen.size(), this.settings.getLimitInMemory());
        }
    }

    private static class IntersectionCursor
    extends AbstractCursor {
        private final HashMap<String, IndexRow> secondSet = new HashMap();
        private final HashSet<String> seen = new HashSet();
        private final Cursor first;
        private final Cursor second;
        private final QueryEngineSettings settings;
        private boolean init;
        private boolean closed;
        private IndexRow current;

        IntersectionCursor(Cursor first, Cursor second, QueryEngineSettings settings) {
            this.first = first;
            this.second = second;
            this.settings = settings;
        }

        @Override
        public IndexRow next() {
            if (this.closed) {
                throw new IllegalStateException("This cursor is closed");
            }
            if (!this.init) {
                this.fetchNext();
                this.init = true;
                if (this.closed) {
                    throw new IllegalStateException("This cursor is closed");
                }
            }
            IndexRow result = this.current;
            this.init = false;
            return result;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        /*
         * Unable to fully structure code
         */
        private void fetchNext() {
            block0: while (true) {
                if (!this.first.hasNext()) {
                    this.closed = true;
                    return;
                }
                c = this.first.next();
                p = c.getPath();
                if (this.seen.contains(p)) continue;
                if (this.secondSet.remove(p) != null) {
                    this.current = c;
                    this.markSeen(p);
                    return;
                }
                while (true) {
                    if (this.second.hasNext()) ** break;
                    continue block0;
                    s = this.second.next();
                    p2 = s.getPath();
                    if (p.equals(p2)) {
                        this.current = c;
                        this.markSeen(p);
                        return;
                    }
                    this.secondSet.put(p2, s);
                    FilterIterators.checkMemoryLimit(this.secondSet.size(), this.settings.getLimitInMemory());
                }
                break;
            }
        }

        private void markSeen(String path) {
            this.seen.add(path);
            FilterIterators.checkMemoryLimit(this.seen.size(), this.settings.getLimitInMemory());
        }
    }

    private static class TraversingCursor
    extends AbstractCursor {
        private static final Logger LOG = LoggerFactory.getLogger(TraversingCursor.class);
        private final Filter filter;
        private final Deque<Iterator<? extends ChildNodeEntry>> nodeIterators = Queues.newArrayDeque();
        private String parentPath;
        private String currentPath;
        private long readCount;
        private boolean init;
        private boolean closed;
        private final long maxReadEntries;

        public TraversingCursor(Filter filter, NodeState rootState) {
            this.filter = filter;
            this.maxReadEntries = filter.getQueryEngineSettings().getLimitReads();
            String path = filter.getPath();
            this.parentPath = null;
            this.currentPath = "/";
            NodeState parent = null;
            NodeState node = rootState;
            if (filter.isAlwaysFalse()) {
                return;
            }
            if (!path.equals("/")) {
                for (String name : path.substring(1).split("/")) {
                    this.parentPath = this.currentPath;
                    this.currentPath = PathUtils.concat(this.parentPath, name);
                    parent = node;
                    node = parent.getChildNode(name);
                }
                if (!node.exists()) {
                    return;
                }
            }
            Filter.PathRestriction restriction = filter.getPathRestriction();
            switch (restriction) {
                case NO_RESTRICTION: 
                case EXACT: 
                case ALL_CHILDREN: {
                    this.nodeIterators.add((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry(this.currentPath, node)));
                    this.parentPath = "";
                    break;
                }
                case PARENT: {
                    if (parent == null) break;
                    this.nodeIterators.add((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry(this.parentPath, parent)));
                    this.parentPath = "";
                    break;
                }
                case DIRECT_CHILDREN: {
                    this.nodeIterators.add(node.getChildNodeEntries().iterator());
                    this.parentPath = this.currentPath;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown restriction: " + (Object)((Object)restriction));
                }
            }
        }

        @Override
        public IndexRow next() {
            if (this.closed) {
                throw new IllegalStateException("This cursor is closed");
            }
            if (!this.init) {
                this.fetchNext();
                this.init = true;
            }
            IndexRowImpl result = new IndexRowImpl(this.currentPath);
            this.fetchNext();
            return result;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        private void fetchNext() {
            while (!this.nodeIterators.isEmpty()) {
                Iterator<? extends ChildNodeEntry> iterator = this.nodeIterators.getLast();
                if (iterator.hasNext()) {
                    ChildNodeEntry entry = iterator.next();
                    ++this.readCount;
                    if (this.readCount % 1000L == 0L) {
                        FilterIterators.checkReadLimit(this.readCount, this.maxReadEntries);
                        LOG.warn("Traversed " + this.readCount + " nodes with filter " + this.filter + "; consider creating an index or changing the query");
                    }
                    NodeState node = entry.getNodeState();
                    String name = entry.getName();
                    if (NodeStateUtils.isHidden(name)) continue;
                    this.currentPath = PathUtils.concat(this.parentPath, name);
                    Filter.PathRestriction r = this.filter.getPathRestriction();
                    if (r == Filter.PathRestriction.ALL_CHILDREN || r == Filter.PathRestriction.NO_RESTRICTION) {
                        this.nodeIterators.addLast(node.getChildNodeEntries().iterator());
                        this.parentPath = this.currentPath;
                    }
                    return;
                }
                this.nodeIterators.removeLast();
                this.parentPath = PathUtils.getParentPath(this.parentPath);
            }
            this.currentPath = null;
            this.closed = true;
        }
    }

    public static class PathCursor
    extends AbstractCursor {
        private final Iterator<String> iterator;

        public PathCursor(Iterator<String> paths, boolean distinct, final QueryEngineSettings settings) {
            UnmodifiableIterator it = paths;
            if (distinct) {
                it = Iterators.filter(it, (Predicate)new Predicate<String>(){
                    private final HashSet<String> known = new HashSet();
                    private final long maxMemoryEntries = settings.getLimitInMemory();

                    public boolean apply(@Nullable String input) {
                        FilterIterators.checkMemoryLimit(this.known.size(), this.maxMemoryEntries);
                        return this.known.add(input);
                    }
                });
            }
            this.iterator = it;
        }

        @Override
        public IndexRow next() {
            String path = this.iterator.next();
            return new IndexRowImpl(PathUtils.isAbsolute(path) ? path : "/" + path);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class AncestorCursor
    extends PathCursor {
        public AncestorCursor(Cursor cursor, int level, QueryEngineSettings settings) {
            super(AncestorCursor.transform(cursor, level), true, settings);
        }

        private static Iterator<String> transform(Cursor cursor, final int level) {
            Iterator unfiltered = Iterators.transform((Iterator)cursor, (Function)new Function<IndexRow, String>(){

                public String apply(@Nullable IndexRow input) {
                    return input != null ? input.getPath() : null;
                }
            });
            UnmodifiableIterator filtered = Iterators.filter((Iterator)unfiltered, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return input != null && PathUtils.getDepth(input) >= level;
                }
            });
            return Iterators.transform((Iterator)filtered, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return PathUtils.getAncestorPath(input, level);
                }
            });
        }
    }

    public static abstract class AbstractCursor
    implements Cursor {
        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

