/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CommitInfo {
    public static final String OAK_UNKNOWN = "oak:unknown";
    public static final CommitInfo EMPTY = new CommitInfo("oak:unknown", "oak:unknown");
    private final String sessionId;
    private final String userId;
    private final long date = System.currentTimeMillis();
    private final Map<String, Object> info;

    public CommitInfo(@Nonnull String sessionId, @Nullable String userId) {
        this(sessionId, userId, Collections.emptyMap());
    }

    public CommitInfo(@Nonnull String sessionId, @Nullable String userId, Map<String, Object> info) {
        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId);
        this.userId = userId == null ? OAK_UNKNOWN : userId;
        this.info = (Map)Preconditions.checkNotNull(info);
    }

    @Nonnull
    public String getSessionId() {
        return this.sessionId;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    public long getDate() {
        return this.date;
    }

    public String getPath() {
        Object path = this.info.get("path");
        return path instanceof String ? (String)path : "/";
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CommitInfo) {
            CommitInfo that = (CommitInfo)object;
            return this.sessionId.equals(that.sessionId) && this.userId.equals(that.userId) && this.date == that.date && this.info.equals(that.info);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sessionId, this.userId, this.date, this.info});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("sessionId", (Object)this.sessionId).add("userId", (Object)this.userId).add("date", this.date).add("info", this.info).toString();
    }
}

