/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.JackrabbitValue;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.BinaryImpl;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class ValueImpl
implements JackrabbitValue {
    private final PropertyState propertyState;
    private final int index;
    private final NamePathMapper namePathMapper;
    private InputStream stream = null;

    public static Blob getBlob(Value value) {
        Preconditions.checkState((boolean)(value instanceof ValueImpl));
        return ((ValueImpl)value).getBlob();
    }

    ValueImpl(PropertyState property, int index, NamePathMapper namePathMapper) {
        Preconditions.checkArgument((index < property.count() ? 1 : 0) != 0);
        this.propertyState = property;
        this.index = index;
        this.namePathMapper = namePathMapper;
    }

    ValueImpl(PropertyState property, NamePathMapper namePathMapper) {
        this(ValueImpl.checkSingleValued(property), 0, namePathMapper);
    }

    Blob getBlob() {
        return this.propertyState.getValue(Type.BINARY, this.index);
    }

    public String getOakString() {
        return this.propertyState.getValue(Type.STRING, this.index);
    }

    private static PropertyState checkSingleValued(PropertyState property) {
        Preconditions.checkArgument((!property.isArray() ? 1 : 0) != 0);
        return property;
    }

    public int getType() {
        return this.propertyState.getType().tag();
    }

    public boolean getBoolean() throws RepositoryException {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 6: {
                return this.propertyState.getValue(Type.BOOLEAN, this.index);
            }
        }
        throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
    }

    public Calendar getDate() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 5: {
                    String value = this.propertyState.getValue(Type.DATE, this.index);
                    return Conversions.convert(value).toCalendar();
                }
                case 3: 
                case 4: 
                case 12: {
                    return Conversions.convert(this.propertyState.getValue(Type.LONG, this.index)).toCalendar();
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to date", (Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return this.propertyState.getValue(Type.DECIMAL, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to decimal", (Throwable)e);
        }
    }

    public double getDouble() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return this.propertyState.getValue(Type.DOUBLE, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to double", (Throwable)e);
        }
    }

    public long getLong() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return this.propertyState.getValue(Type.LONG, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to long", (Throwable)e);
        }
    }

    public String getString() throws RepositoryException {
        Preconditions.checkState((this.getType() != 2 || this.stream == null ? 1 : 0) != 0, (Object)"getStream has previously been called on this Value instance. In this case a new Value instance must be acquired in order to successfully call this method.");
        switch (this.getType()) {
            case 7: {
                return this.namePathMapper.getJcrName(this.getOakString());
            }
            case 8: {
                String s = this.getOakString();
                if (s.startsWith("[") && s.endsWith("]")) {
                    return s;
                }
                return this.namePathMapper.getJcrPath(s);
            }
        }
        return this.getOakString();
    }

    public InputStream getStream() throws IllegalStateException {
        if (this.stream == null) {
            this.stream = this.getBlob().getNewStream();
        }
        return this.stream;
    }

    public Binary getBinary() throws RepositoryException {
        return new BinaryImpl(this);
    }

    @Override
    public String getContentIdentity() {
        return this.getBlob().getContentIdentity();
    }

    public boolean equals(Object other) {
        if (other instanceof ValueImpl) {
            ValueImpl that = (ValueImpl)other;
            Type<?> type = this.propertyState.getType();
            if (type.isArray()) {
                type = type.getBaseType();
            }
            return type.tag() == that.propertyState.getType().tag() && Objects.equal(this.propertyState.getValue(type, this.index), that.propertyState.getValue(type, that.index));
        }
        return false;
    }

    public int hashCode() {
        if (this.getType() == 2) {
            return this.propertyState.getValue(Type.BINARY, this.index).hashCode();
        }
        return this.getOakString().hashCode();
    }

    public String toString() {
        return this.getOakString();
    }
}

