/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class RelativePathSelector
implements UniversalFilter.Selector {
    private final Iterable<String> path;
    private final UniversalFilter.Selector selector;

    public RelativePathSelector(@Nonnull String path, @Nonnull UniversalFilter.Selector selector) {
        this.path = PathUtils.elements((String)Preconditions.checkNotNull((Object)path));
        this.selector = (UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector);
    }

    @Override
    @Nonnull
    public NodeState select(@Nonnull UniversalFilter filter, @CheckForNull PropertyState before, @CheckForNull PropertyState after) {
        return this.select(this.selector.select(filter, before, after));
    }

    @Override
    @Nonnull
    public NodeState select(@Nonnull UniversalFilter filter, @Nonnull String name, @Nonnull NodeState before, @Nonnull NodeState after) {
        return this.select(this.selector.select(filter, name, before, after));
    }

    private NodeState select(NodeState node) {
        for (String name : this.path) {
            node = node.getChildNode(name);
        }
        return node;
    }
}

