/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class EffectiveType {
    private final List<NodeState> types;

    EffectiveType(List<NodeState> types) {
        this.types = (List)Preconditions.checkNotNull(types);
    }

    boolean isNodeType(String name) {
        for (NodeState type : this.types) {
            if (!name.equals(type.getName("jcr:nodeTypeName")) && !Iterables.contains(type.getNames("rep:supertypes"), (Object)name)) continue;
            return true;
        }
        return false;
    }

    boolean isMandatoryProperty(String name) {
        return this.nameSetContains("rep:mandatoryProperties", name);
    }

    @Nonnull
    Set<String> getMandatoryProperties() {
        return this.getNameSet("rep:mandatoryProperties");
    }

    boolean isMandatoryChildNode(String name) {
        return this.nameSetContains("rep:mandatoryChildNodes", name);
    }

    @Nonnull
    Set<String> getMandatoryChildNodes() {
        return this.getNameSet("rep:mandatoryChildNodes");
    }

    @CheckForNull
    NodeState getDefinition(PropertyState property) {
        NodeState definition;
        String propertyName = property.getName();
        Type<?> propertyType = property.getType();
        String escapedName = "jcr:primaryType".equals(propertyName) ? "rep:primaryType" : ("jcr:mixinTypes".equals(propertyName) ? "rep:mixinTypes" : ("jcr:uuid".equals(propertyName) ? "rep:uuid" : propertyName));
        String definedType = propertyType.toString();
        String undefinedType = propertyType.isArray() ? Type.UNDEFINEDS.toString() : Type.UNDEFINED.toString();
        for (NodeState type : this.types) {
            NodeState definitions = type.getChildNode("rep:namedPropertyDefinitions").getChildNode(escapedName);
            definition = definitions.getChildNode(definedType);
            if (definition.exists()) {
                return definition;
            }
            definition = definitions.getChildNode(undefinedType);
            if (definition.exists()) {
                return definition;
            }
            for (ChildNodeEntry childNodeEntry : definitions.getChildNodeEntries()) {
                definition = childNodeEntry.getNodeState();
                if (!definition.getBoolean("jcr:mandatory")) continue;
                return definition;
            }
        }
        for (NodeState type : this.types) {
            NodeState residual = type.getChildNode("rep:residualPropertyDefinitions");
            definition = residual.getChildNode(definedType);
            if (!definition.exists()) {
                definition = residual.getChildNode(undefinedType);
            }
            if (!definition.exists()) continue;
            return definition;
        }
        return null;
    }

    boolean isValidChildNode(String nameWithIndex, EffectiveType effective) {
        NodeState definition;
        String name = PathUtils.dropIndexFromName(nameWithIndex);
        boolean sns = !name.equals(nameWithIndex);
        Set<String> typeNames = effective.getTypeNames();
        for (NodeState type : this.types) {
            NodeState definitions = type.getChildNode("rep:namedChildNodeDefinitions").getChildNode(name);
            for (String string : typeNames) {
                definition = definitions.getChildNode(string);
                if (!definition.exists() || !this.snsMatch(sns, definition)) continue;
                return true;
            }
            for (ChildNodeEntry childNodeEntry : definitions.getChildNodeEntries()) {
                definition = childNodeEntry.getNodeState();
                if (!definition.getBoolean("jcr:mandatory")) continue;
                return false;
            }
        }
        for (NodeState type : this.types) {
            NodeState residual = type.getChildNode("rep:residualChildNodeDefinitions");
            for (String string : typeNames) {
                definition = residual.getChildNode(string);
                if (!definition.exists() || !this.snsMatch(sns, definition)) continue;
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    String getDefaultType(String nameWithIndex) {
        String name = PathUtils.dropIndexFromName(nameWithIndex);
        boolean sns = !name.equals(nameWithIndex);
        for (NodeState type : this.types) {
            NodeState named = type.getChildNode("rep:namedChildNodeDefinitions").getChildNode(name);
            NodeState residual = type.getChildNode("rep:residualChildNodeDefinitions");
            for (ChildNodeEntry entry : Iterables.concat(named.getChildNodeEntries(), residual.getChildNodeEntries())) {
                NodeState definition = entry.getNodeState();
                String defaultType = definition.getName("jcr:defaultPrimaryType");
                if (defaultType == null || !this.snsMatch(sns, definition)) continue;
                return defaultType;
            }
        }
        return null;
    }

    Set<String> getTypeNames() {
        HashSet names = Sets.newHashSet();
        for (NodeState type : this.types) {
            names.add(type.getName("jcr:nodeTypeName"));
            Iterables.addAll((Collection)names, type.getNames("rep:supertypes"));
        }
        return names;
    }

    public String toString() {
        ArrayList names = Lists.newArrayListWithCapacity((int)this.types.size());
        for (NodeState type : this.types) {
            names.add(type.getName("jcr:nodeTypeName"));
        }
        return ((Object)names).toString();
    }

    private boolean snsMatch(boolean sns, NodeState definition) {
        return !sns || definition.getBoolean("jcr:sameNameSiblings");
    }

    private boolean nameSetContains(String set, String name) {
        for (NodeState type : this.types) {
            if (!Iterables.contains(type.getNames(set), (Object)name)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private Set<String> getNameSet(String set) {
        HashSet names = Sets.newHashSet();
        for (NodeState type : this.types) {
            Iterables.addAll((Collection)names, type.getNames(set));
        }
        return names;
    }
}

