/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.reference;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class ReferenceIndex
implements QueryIndex {
    private static ContentMirrorStoreStrategy STORE = new ContentMirrorStoreStrategy();

    ReferenceIndex() {
    }

    @Override
    public String getIndexName() {
        return "reference";
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (pr.propertyType != 9 && pr.propertyType != 10) continue;
            return 1.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (pr.propertyType == 9) {
                String uuid = pr.first.getValue(Type.STRING);
                String name = pr.propertyName;
                return ReferenceIndex.lookup(root, uuid, name, ":references", filter);
            }
            if (pr.propertyType != 10) continue;
            String uuid = pr.first.getValue(Type.STRING);
            String name = pr.propertyName;
            return ReferenceIndex.lookup(root, uuid, name, ":weakreferences", filter);
        }
        return Cursors.newPathCursor(new ArrayList<String>(), filter.getQueryEngineSettings());
    }

    private static Cursor lookup(NodeState root, String uuid, final String name, String index, Filter filter) {
        NodeState indexRoot = root.getChildNode("oak:index").getChildNode("reference");
        if (!indexRoot.exists()) {
            return Cursors.newPathCursor(new ArrayList<String>(), filter.getQueryEngineSettings());
        }
        Iterable paths = STORE.query((Filter)new FilterImpl(), index + "(" + uuid + ")", indexRoot, index, (Iterable)ImmutableSet.of((Object)uuid));
        if (!"*".equals(name)) {
            paths = Iterables.filter((Iterable)paths, (Predicate)new Predicate<String>(){

                public boolean apply(String path) {
                    return name.equals(PathUtils.getName(path));
                }
            });
        }
        paths = Iterables.transform((Iterable)paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return PathUtils.getParentPath(path);
            }
        });
        return Cursors.newPathCursor(paths, filter.getQueryEngineSettings());
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        StringBuilder buff = new StringBuilder("reference");
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (pr.propertyType == 9) {
                buff.append(" PROPERTY([");
                buff.append(pr.propertyName);
                buff.append("], 'Reference') = ");
                buff.append(pr.first.getValue(Type.STRING));
                return buff.toString();
            }
            if (pr.propertyType != 10) continue;
            buff.append(" PROPERTY([");
            buff.append(pr.propertyName);
            buff.append("], 'WeakReference') = ");
            buff.append(pr.first.getValue(Type.STRING));
            return buff.toString();
        }
        return buff.toString();
    }
}

