/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexTracker {
    private static final Logger log = LoggerFactory.getLogger(IndexTracker.class);
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private final Map<String, IndexNode> indices = Maps.newHashMap();

    IndexTracker() {
    }

    synchronized void close() {
        for (Map.Entry<String, IndexNode> entry : this.indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at " + entry.getKey(), (Throwable)e);
            }
        }
        this.indices.clear();
    }

    synchronized void update(NodeState root) {
        ArrayList editors = Lists.newArrayListWithCapacity((int)this.indices.size());
        for (final String path : this.indices.keySet()) {
            ArrayList elements = Lists.newArrayList();
            Iterables.addAll((Collection)elements, PathUtils.elements(path));
            elements.add("oak:index");
            elements.add(this.indices.get(path).getName());
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                @Override
                public void leave(NodeState before, NodeState after) {
                    IndexNode index = (IndexNode)IndexTracker.this.indices.remove(path);
                    try {
                        index.close();
                    }
                    catch (IOException e) {
                        log.error("Failed to close Lucene index at " + path, (Throwable)e);
                    }
                    try {
                        index = IndexNode.open(index.getName(), after);
                        if (index != null) {
                            IndexTracker.this.indices.put(path, index);
                        }
                    }
                    catch (IOException e) {
                        log.error("Failed to open Lucene index at " + path, (Throwable)e);
                    }
                }
            }, elements.toArray(new String[elements.size()])));
        }
        EditorDiff.process(CompositeEditor.compose(editors), this.root, root);
        this.root = root;
    }

    synchronized IndexNode getIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null) {
            return index;
        }
        NodeState node = this.root;
        for (String string : PathUtils.elements(path)) {
            node = this.root.getChildNode(string);
        }
        node = node.getChildNode("oak:index");
        try {
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
                node = childNodeEntry.getNodeState();
                if (!"lucene".equals(node.getString("type")) || (index = IndexNode.open(childNodeEntry.getName(), node)) == null) continue;
                this.indices.put(path, index);
                return index;
            }
        }
        catch (IOException e) {
            log.error("Could not access the Lucene index at " + path, (Throwable)e);
        }
        return null;
    }
}

