/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.GlobalNameMapper;

public class LocalNameMapper
extends GlobalNameMapper {
    protected final Map<String, String> local;

    public LocalNameMapper(Root root, Map<String, String> local) {
        super(root);
        this.local = local;
    }

    public LocalNameMapper(Map<String, String> global, Map<String, String> local) {
        super(global);
        this.local = local;
    }

    @Override
    @Nonnull
    public synchronized Map<String, String> getSessionLocalMappings() {
        return this.local;
    }

    @Override
    @CheckForNull
    public synchronized String getJcrName(String oakName) {
        int colon;
        Preconditions.checkNotNull((Object)oakName);
        Preconditions.checkArgument((!oakName.startsWith(":") ? 1 : 0) != 0, (Object)oakName);
        Preconditions.checkArgument((!LocalNameMapper.isExpandedName(oakName) ? 1 : 0) != 0, (Object)oakName);
        if (!this.local.isEmpty() && (colon = oakName.indexOf(58)) > 0) {
            String oakPrefix = oakName.substring(0, colon);
            PropertyState mapping = this.namespaces.getProperty(oakPrefix);
            if (mapping == null || mapping.getType() != Type.STRING) {
                throw new IllegalStateException("No namespace mapping found for " + oakName);
            }
            String uri = mapping.getValue(Type.STRING);
            for (Map.Entry<String, String> entry : this.local.entrySet()) {
                if (!uri.equals(entry.getValue())) continue;
                String jcrPrefix = entry.getKey();
                if (jcrPrefix.equals(oakPrefix)) {
                    return oakName;
                }
                return jcrPrefix + oakName.substring(colon);
            }
            if (this.local.containsKey(oakPrefix)) {
                int i = 2;
                while (true) {
                    String jcrPrefix;
                    if (!this.local.containsKey(jcrPrefix = oakPrefix + i)) {
                        return jcrPrefix + oakName.substring(colon);
                    }
                    ++i;
                }
            }
        }
        return oakName;
    }

    @Override
    @CheckForNull
    public synchronized String getOakNameOrNull(String jcrName) {
        int colon;
        String oakName;
        Preconditions.checkNotNull((Object)jcrName);
        if (jcrName.startsWith("{") && (oakName = this.getOakNameFromExpanded(jcrName)) != jcrName) {
            return oakName;
        }
        if (!this.local.isEmpty() && (colon = jcrName.indexOf(58)) > 0) {
            String jcrPrefix = jcrName.substring(0, colon);
            String uri = this.local.get(jcrPrefix);
            if (uri != null) {
                String oakPrefix = this.getOakPrefixOrNull(uri);
                if (oakPrefix == null) {
                    return null;
                }
                if (jcrPrefix.equals(oakPrefix)) {
                    return jcrName;
                }
                return oakPrefix + jcrName.substring(colon);
            }
            PropertyState mapping = this.namespaces.getProperty(jcrPrefix);
            if (mapping != null && mapping.getType() == Type.STRING && this.local.values().contains(mapping.getValue(Type.STRING))) {
                return null;
            }
        }
        return jcrName;
    }
}

