/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.kernel.KernelBlob;
import org.apache.jackrabbit.oak.kernel.KernelNodeStore;
import org.apache.jackrabbit.oak.kernel.KernelRootBuilder;
import org.apache.jackrabbit.oak.kernel.StringCache;
import org.apache.jackrabbit.oak.kernel.TypeCodes;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public final class KernelNodeState
extends AbstractNodeState {
    public static final int MAX_CHILD_NAMES = 100;
    public static final int LOCAL_DIFF_THRESHOLD = 10;
    private static final LoadingCache<String, KernelNodeState> DUMMY_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, KernelNodeState>(){

        public KernelNodeState load(String key) throws Exception {
            throw new UnsupportedOperationException();
        }
    });
    private static final KernelNodeState NULL = new KernelNodeState();
    private final KernelNodeStore store;
    private final MicroKernel kernel;
    private final String path;
    private String revision;
    private Map<String, PropertyState> properties;
    private long childNodeCount = -1L;
    private long childNodeCountMin;
    private String hash;
    private String id;
    private Set<String> childNames;
    private boolean isBranch;
    private final LoadingCache<String, KernelNodeState> cache;

    public KernelNodeState(KernelNodeStore store, String path, String revision, LoadingCache<String, KernelNodeState> cache) {
        this.store = store;
        this.kernel = store.getKernel();
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.revision = (String)Preconditions.checkNotNull((Object)revision);
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache);
    }

    private KernelNodeState() {
        this.store = null;
        this.kernel = null;
        this.path = "null";
        this.revision = "null";
        this.cache = DUMMY_CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        boolean initialized = false;
        KernelNodeState kernelNodeState = this;
        synchronized (kernelNodeState) {
            if (this.properties == null) {
                String json = this.kernel.getNodes(this.path, this.revision, 0, 0L, 100, "{\"properties\":[\"*\",\":hash\",\":id\"]}");
                Preconditions.checkNotNull((Object)json, (String)"No node found at path [%s] for revision [%s]", (Object[])new Object[]{this.path, this.revision});
                JsopTokenizer reader = new JsopTokenizer(json);
                reader.read(123);
                this.properties = new LinkedHashMap<String, PropertyState>();
                this.childNames = new LinkedHashSet<String>();
                do {
                    String name = StringCache.get(reader.readString());
                    reader.read(58);
                    if (":childNodeCount".equals(name)) {
                        this.childNodeCount = Long.valueOf(reader.read(2));
                        continue;
                    }
                    if (":hash".equals(name)) {
                        this.hash = new String(reader.read(1));
                        if (!this.hash.equals(this.id)) continue;
                        this.hash = this.id;
                        continue;
                    }
                    if (":id".equals(name)) {
                        this.id = new String(reader.read(1));
                        if (!this.id.equals(this.hash)) continue;
                        this.id = this.hash;
                        continue;
                    }
                    if (reader.matches(123)) {
                        reader.read(125);
                        this.childNames.add(name);
                        continue;
                    }
                    if (reader.matches(91)) {
                        this.properties.put(name, this.readArrayProperty(name, reader));
                        continue;
                    }
                    this.properties.put(name, this.readProperty(name, reader));
                } while (reader.matches(44));
                reader.read(125);
                reader.read(0);
                if (this.childNames.isEmpty()) {
                    this.childNames = Collections.emptySet();
                }
                initialized = true;
            }
        }
        if (initialized) {
            this.cache.refresh((Object)(this.revision + this.path));
        }
        if (initialized && !PathUtils.denotesRoot(this.path)) {
            String hashOrId = null;
            if (this.hash != null) {
                hashOrId = this.hash;
            } else if (this.id != null) {
                hashOrId = this.id;
            }
            if (hashOrId != null) {
                KernelNodeState cached = (KernelNodeState)this.cache.getIfPresent((Object)hashOrId);
                if (cached != null && cached.path.equals(this.path)) {
                    KernelNodeState kernelNodeState2 = this;
                    synchronized (kernelNodeState2) {
                        this.revision = cached.revision;
                        this.childNames = cached.childNames;
                        this.properties = cached.properties;
                    }
                } else {
                    this.cache.put((Object)hashOrId, (Object)this);
                }
            }
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getPropertyCount() {
        this.init();
        return this.properties.size();
    }

    @Override
    public boolean hasProperty(String name) {
        this.init();
        return this.properties.containsKey(name);
    }

    @Override
    public PropertyState getProperty(String name) {
        this.init();
        return this.properties.get(name);
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        this.init();
        return this.properties.values();
    }

    @Override
    public long getChildNodeCount(long max) {
        this.init();
        if (this.childNodeCount == Long.MAX_VALUE) {
            long n;
            if (this.childNodeCountMin > max) {
                return this.childNodeCountMin;
            }
            Iterator<? extends ChildNodeEntry> iterator = this.getChildNodeEntries().iterator();
            for (n = 0L; n <= max; ++n) {
                if (!iterator.hasNext()) {
                    this.childNodeCount = n;
                    return n;
                }
                iterator.next();
            }
            this.childNodeCountMin = n;
            if (n == max) {
                return max;
            }
        }
        return this.childNodeCount;
    }

    @Override
    public boolean hasChildNode(String name) {
        this.init();
        if (this.childNames.contains(name)) {
            return true;
        }
        if (this.getChildNodeCount(100L) <= 100L) {
            return false;
        }
        return KernelNodeState.isValidName(name) && this.getChildNode(name).exists();
    }

    @Override
    public NodeState getChildNode(String name) {
        this.init();
        String childPath = null;
        if (this.childNames.contains(name)) {
            childPath = PathUtils.concat(this.path, name);
        } else {
            if (!KernelNodeState.isValidName(name)) {
                throw new IllegalArgumentException("Invalid name: " + name);
            }
            if (this.getChildNodeCount(100L) <= 100L) {
                return EmptyNodeState.MISSING_NODE;
            }
            childPath = PathUtils.concat(this.path, name);
            NodeState state = (NodeState)this.cache.getIfPresent((Object)(this.revision + childPath));
            if (state == NULL) {
                return EmptyNodeState.MISSING_NODE;
            }
            if (state != null) {
                return state;
            }
            if (!this.kernel.nodeExists(childPath, this.revision)) {
                this.cache.put((Object)(this.revision + childPath), (Object)NULL);
                return EmptyNodeState.MISSING_NODE;
            }
        }
        try {
            return (NodeState)this.cache.get((Object)(this.revision + childPath));
        }
        catch (ExecutionException e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        this.init();
        if (this.childNodeCount <= 100L && this.childNodeCount <= (long)this.childNames.size()) {
            return this.iterable(this.childNames);
        }
        ArrayList iterables = Lists.newArrayList();
        iterables.add(this.iterable(this.childNames));
        iterables.add(this.getChildNodeEntries(this.childNames.size()));
        return Iterables.concat((Iterable)iterables);
    }

    private Iterable<ChildNodeEntry> getChildNodeEntries(final long offset) {
        return new Iterable<ChildNodeEntry>(){

            @Override
            public Iterator<ChildNodeEntry> iterator() {
                return new Iterator<ChildNodeEntry>(){
                    private long currentOffset;
                    private Iterator<ChildNodeEntry> current;
                    {
                        this.currentOffset = offset;
                        this.fetchEntries();
                    }

                    private void fetchEntries() {
                        ArrayList entries = Lists.newArrayListWithCapacity((int)100);
                        String json = KernelNodeState.this.kernel.getNodes(KernelNodeState.this.path, KernelNodeState.this.revision, 0, this.currentOffset, 100, null);
                        JsopTokenizer reader = new JsopTokenizer(json);
                        reader.read(123);
                        do {
                            String name = StringCache.get(reader.readString());
                            reader.read(58);
                            if (reader.matches(123)) {
                                reader.read(125);
                                entries.add(new KernelChildNodeEntry(name));
                                continue;
                            }
                            if (reader.matches(91)) {
                                while (reader.read() != 93) {
                                }
                            } else {
                                reader.read();
                            }
                        } while (reader.matches(44));
                        reader.read(125);
                        reader.read(0);
                        if (entries.isEmpty()) {
                            this.current = null;
                        } else {
                            this.currentOffset += (long)entries.size();
                            this.current = entries.iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.current != null) {
                            if (this.current.hasNext()) {
                                return true;
                            }
                            this.fetchEntries();
                        }
                        return false;
                    }

                    @Override
                    public ChildNodeEntry next() {
                        if (!this.hasNext()) {
                            throw new IllegalStateException("Reading past the end");
                        }
                        return this.current.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public NodeBuilder builder() {
        if (this.isBranch) {
            return new MemoryNodeBuilder(this);
        }
        if ("/".equals(this.path)) {
            return new KernelRootBuilder(this, this.store);
        }
        return new MemoryNodeBuilder(this);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState(this, diff);
        }
        if (base instanceof KernelNodeState) {
            KernelNodeState kbase = (KernelNodeState)base;
            if (this.kernel.equals(kbase.kernel)) {
                if (this.revision.equals(kbase.revision) && this.path.equals(kbase.path)) {
                    return true;
                }
                this.init();
                kbase.init();
                if (this.hash != null && this.hash.equals(kbase.hash)) {
                    return true;
                }
                if (this.id != null && this.id.equals(kbase.id)) {
                    return true;
                }
                if (this.path.equals(kbase.path) && this.getChildNodeCount(10L) > 10L) {
                    String jsonDiff = this.kernel.diff(kbase.getRevision(), this.revision, this.path, 0);
                    return this.processJsonDiff(jsonDiff, kbase, diff);
                }
            }
        }
        return super.compareAgainstBaseState(base, diff);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KernelNodeState) {
            KernelNodeState that = (KernelNodeState)object;
            if (this.kernel.equals(that.kernel)) {
                if (this.revision.equals(that.revision) && this.path.equals(that.path)) {
                    return true;
                }
                this.init();
                that.init();
                if (this.hash != null && that.hash != null) {
                    return this.hash.equals(that.hash);
                }
                if (this.id != null && this.id.equals(that.id)) {
                    return true;
                }
                if (this.path.equals(that.path) && !this.path.equals("/")) {
                    String jsonDiff;
                    String r1 = this.revision;
                    String r2 = that.getRevision();
                    if (r1.compareTo(r2) > 0) {
                        String temp = r1;
                        r1 = r2;
                        r2 = temp;
                    }
                    return !KernelNodeState.hasChanges(jsonDiff = this.kernel.diff(r1, r2, this.path, 0));
                }
            }
        }
        return super.equals(object);
    }

    @Nonnull
    String getRevision() {
        return this.revision;
    }

    KernelNodeState setBranch() {
        this.isBranch = true;
        return this;
    }

    boolean isBranch() {
        return this.isBranch;
    }

    synchronized int getMemory() {
        int memory = 64;
        memory += 48 + this.path.length() * 2;
        memory += 48 + this.revision.length() * 2;
        if (this.hash != null) {
            memory += 48 + this.hash.length() * 2;
        }
        if (this.id != null && !this.id.equals(this.hash)) {
            memory += 48 + this.id.length() * 2;
        }
        if (this.properties != null) {
            for (Map.Entry<String, PropertyState> entry : this.properties.entrySet()) {
                memory += 48 + entry.getKey().length() * 2;
                PropertyState propState = entry.getValue();
                if (propState.getType() == Type.BINARY || propState.getType() == Type.BINARIES) continue;
                for (int i = 0; i < propState.count(); ++i) {
                    memory = (int)((long)memory + (56L + propState.size(i) * 2L));
                }
            }
        }
        if (this.childNames != null) {
            memory += this.childNames.size() * 150;
        }
        return memory;
    }

    private static boolean hasChanges(String journal) {
        return !journal.trim().isEmpty();
    }

    private boolean processJsonDiff(String jsonDiff, KernelNodeState base, NodeStateDiff diff) {
        int r;
        if (!KernelNodeState.hasChanges(jsonDiff)) {
            return true;
        }
        if (!AbstractNodeState.comparePropertiesAgainstBaseState(this, base, diff)) {
            return false;
        }
        JsopTokenizer t = new JsopTokenizer(jsonDiff);
        boolean continueComparison = true;
        block6: while (continueComparison && (r = t.read()) != 0) {
            switch (r) {
                case 43: {
                    String path = t.readString();
                    t.read(58);
                    t.read(123);
                    while (t.read() != 125) {
                    }
                    String name = PathUtils.getName(path);
                    continueComparison = diff.childNodeAdded(name, this.getChildNode(name));
                    break;
                }
                case 45: {
                    String path = t.readString();
                    String name = PathUtils.getName(path);
                    continueComparison = diff.childNodeDeleted(name, base.getChildNode(name));
                    break;
                }
                case 94: {
                    String name;
                    String path = t.readString();
                    t.read(58);
                    if (t.matches(123)) {
                        t.read(125);
                        name = PathUtils.getName(path);
                        continueComparison = diff.childNodeChanged(name, base.getChildNode(name), this.getChildNode(name));
                        break;
                    }
                    if (t.matches(91)) {
                        while (t.read() != 93) {
                        }
                        continue block6;
                    }
                    t.read();
                    break;
                }
                case 62: {
                    String from = t.readString();
                    t.read(58);
                    String to = t.readString();
                    String fromName = PathUtils.getName(from);
                    continueComparison = diff.childNodeDeleted(fromName, base.getChildNode(fromName));
                    if (!continueComparison) break;
                    String toName = PathUtils.getName(to);
                    continueComparison = diff.childNodeAdded(toName, this.getChildNode(toName));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + ' ' + jsonDiff);
                }
            }
        }
        return continueComparison;
    }

    private Iterable<ChildNodeEntry> iterable(Iterable<String> names) {
        return Iterables.transform(names, (Function)new Function<String, ChildNodeEntry>(){

            public ChildNodeEntry apply(String input) {
                return new KernelChildNodeEntry(input);
            }
        });
    }

    private PropertyState readProperty(String name, JsopReader reader) {
        if (reader.matches(2)) {
            String number = reader.getToken();
            try {
                return new LongPropertyState(name, Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                return new DoublePropertyState(name, Double.parseDouble(number));
            }
        }
        if (reader.matches(3)) {
            return BooleanPropertyState.booleanProperty(name, true);
        }
        if (reader.matches(4)) {
            return BooleanPropertyState.booleanProperty(name, false);
        }
        if (reader.matches(1)) {
            String jsonString = reader.getToken();
            if (jsonString.startsWith("[0]:")) {
                int type = PropertyType.valueFromName((String)jsonString.substring("[0]:".length()));
                return PropertyStates.createProperty(name, Collections.emptyList(), Type.fromTag(type, true));
            }
            int split = TypeCodes.split(jsonString);
            if (split != -1) {
                int type = TypeCodes.decodeType(split, jsonString);
                String value = TypeCodes.decodeName(split, jsonString);
                if (type == 2) {
                    return BinaryPropertyState.binaryProperty(name, new KernelBlob(new String(value), this.kernel));
                }
                return PropertyStates.createProperty(name, StringCache.get(value), type);
            }
            return StringPropertyState.stringProperty(name, StringCache.get(jsonString));
        }
        throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
    }

    private PropertyState readArrayProperty(String name, JsopReader reader) {
        int type = 1;
        ArrayList values = Lists.newArrayList();
        while (!reader.matches(93)) {
            if (reader.matches(2)) {
                String number = reader.getToken();
                try {
                    type = 3;
                    values.add(Long.parseLong(number));
                }
                catch (NumberFormatException e) {
                    type = 4;
                    values.add(Double.parseDouble(number));
                }
            } else if (reader.matches(3)) {
                type = 6;
                values.add(true);
            } else if (reader.matches(4)) {
                type = 6;
                values.add(false);
            } else if (reader.matches(1)) {
                String jsonString = reader.getToken();
                int split = TypeCodes.split(jsonString);
                if (split != -1) {
                    type = TypeCodes.decodeType(split, jsonString);
                    String value = TypeCodes.decodeName(split, jsonString);
                    if (type == 2) {
                        values.add(new KernelBlob(new String(value), this.kernel));
                    } else if (type == 4) {
                        values.add(Conversions.convert(value).toDouble());
                    } else if (type == 12) {
                        values.add(Conversions.convert(value).toDecimal());
                    } else {
                        values.add(StringCache.get(value));
                    }
                } else {
                    type = 1;
                    values.add(StringCache.get(jsonString));
                }
            } else {
                throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
            }
            reader.matches(44);
        }
        return PropertyStates.createProperty(name, (Object)values, Type.fromTag(type, true));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.path).append('@').append(this.revision);
        if (this.childNodeCount >= 0L) {
            builder.append(" children: ").append(this.childNodeCount);
        }
        if (this.hash != null) {
            builder.append(" hash: ").append(this.hash);
        }
        if (this.id != null) {
            builder.append(" id: ").append(this.id);
        }
        builder.append(" {");
        int count = 0;
        if (this.properties == null) {
            builder.append(" /* props not initialized */");
        } else {
            for (PropertyState propertyState : this.getProperties()) {
                if (count++ > 0) {
                    builder.append(',');
                }
                builder.append(' ').append(propertyState);
            }
        }
        if (this.childNames == null) {
            builder.append(" /* child node names not initialized */");
        } else {
            for (String string : this.childNames) {
                if (count++ > 0) {
                    builder.append(',');
                }
                builder.append(' ').append(string);
            }
        }
        builder.append(" }");
        return builder.toString();
    }

    private class KernelChildNodeEntry
    extends AbstractChildNodeEntry {
        private final String name;

        public KernelChildNodeEntry(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public NodeState getNodeState() {
            try {
                return (NodeState)KernelNodeState.this.cache.get((Object)(KernelNodeState.this.revision + PathUtils.concat(KernelNodeState.this.path, this.name)));
            }
            catch (ExecutionException e) {
                throw new MicroKernelException(e);
            }
        }
    }
}

