/*
 * Decompiled with CFR 0.152.
 */
package io.sightly.java.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

public class StackedWriter
extends Writer {
    private final PrintWriter baseWriter;
    private final Stack<StringWriter> writerStack = new Stack();
    private PrintWriter current;

    public StackedWriter(PrintWriter baseWriter) {
        this.baseWriter = baseWriter;
        this.current = baseWriter;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.current.write(cbuf, off, len);
    }

    @Override
    public void write(String text) {
        this.current.write(text);
    }

    @Override
    public void flush() throws IOException {
        this.current.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writerStack.size() != 1) {
            throw new UnsupportedOperationException("Stack is not empty");
        }
        this.current.close();
    }

    public void push() {
        StringWriter writer = new StringWriter();
        this.writerStack.push(writer);
        this.current = new PrintWriter(writer);
    }

    public String pop() {
        String output = null;
        if (!this.writerStack.isEmpty()) {
            StringWriter writer = this.writerStack.pop();
            output = writer.toString();
        }
        this.current = this.writerStack.isEmpty() ? this.baseWriter : new PrintWriter(this.writerStack.peek());
        return output;
    }
}

