/*
 * Decompiled with CFR 0.152.
 */
package io.sightly.java.api;

import io.sightly.java.api.ObjectModel;
import io.sightly.java.api.SightlyRuntime;
import io.sightly.java.api.StackedWriter;
import io.sightly.java.api.UnitLocator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public class RenderContext {
    private final StackedWriter writer;
    private final Bindings bindings;
    private final ObjectModel objectModel;
    private final SightlyRuntime runtime;
    private final UnitLocator unitLocator;

    public RenderContext(StackedWriter writer, Bindings bindings, ObjectModel objectModel, SightlyRuntime runtime, UnitLocator unitLocator) {
        this.writer = writer;
        this.bindings = bindings;
        this.objectModel = objectModel;
        this.runtime = runtime;
        this.unitLocator = unitLocator;
    }

    public StackedWriter getWriter() {
        return this.writer;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public ObjectModel getObjectModel() {
        return this.objectModel;
    }

    public SightlyRuntime getRuntime() {
        return this.runtime;
    }

    public UnitLocator getUnitLocator() {
        return this.unitLocator;
    }

    public RenderContext withBindings(Bindings newBindings) {
        return new RenderContext(this.writer, newBindings, this.objectModel, this.runtime, this.unitLocator);
    }

    public RenderContext withAddedBindings(Map additionalBindings) {
        SimpleBindings newBindings = new SimpleBindings();
        newBindings.putAll(this.bindings);
        newBindings.putAll(additionalBindings);
        return this.withBindings(newBindings);
    }
}

