/*
 * Decompiled with CFR 0.152.
 */
package io.sightly.java.api;

import io.sightly.java.api.ObjectModel;
import io.sightly.java.api.RenderContext;
import io.sightly.java.api.RenderUnit;
import io.sightly.java.api.SightlyRuntime;
import io.sightly.java.api.StackedWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public abstract class BaseRenderUnit
implements RenderUnit {
    private final Map<String, RenderUnit> subTemplates = new HashMap<String, RenderUnit>();
    private Map<String, RenderUnit> siblings;

    @Override
    public final void render(RenderContext renderContext, Bindings arguments) {
        this.render(renderContext.getWriter(), this.buildGlobalScope(renderContext.getBindings()), new CaseInsensitiveBindings(arguments), renderContext.getObjectModel(), renderContext.getRuntime(), renderContext);
    }

    @Override
    public RenderUnit get(String name) {
        return this.subTemplates.get(name.toLowerCase());
    }

    @Override
    public Set<String> properties() {
        return this.subTemplates.keySet();
    }

    protected abstract void render(StackedWriter var1, Bindings var2, Bindings var3, ObjectModel var4, SightlyRuntime var5, RenderContext var6);

    protected void callUnit(RenderContext renderContext, Object templateObj, Object argsObj) {
        if (!(templateObj instanceof RenderUnit)) {
            return;
        }
        RenderUnit unit = (RenderUnit)templateObj;
        ObjectModel dynamic = renderContext.getObjectModel();
        Map argumentsMap = dynamic.coerceToMap(argsObj);
        SimpleBindings arguments = new SimpleBindings(Collections.unmodifiableMap(argumentsMap));
        unit.render(renderContext, arguments);
    }

    protected FluentMap obj() {
        return new FluentMap();
    }

    protected final void addSubTemplate(String name, BaseRenderUnit renderUnit) {
        renderUnit.setSiblings(this.subTemplates);
        this.subTemplates.put(name.toLowerCase(), renderUnit);
    }

    private void setSiblings(Map<String, RenderUnit> siblings) {
        this.siblings = siblings;
    }

    private Bindings buildGlobalScope(Bindings bindings) {
        SimpleBindings simpleBindings = new SimpleBindings(bindings);
        simpleBindings.putAll(bindings);
        if (this.siblings != null) {
            simpleBindings.putAll((Map<? extends String, ? extends Object>)this.siblings);
        }
        simpleBindings.putAll((Map<? extends String, ? extends Object>)this.subTemplates);
        return new CaseInsensitiveBindings(simpleBindings);
    }

    private static final class CaseInsensitiveBindings
    extends SimpleBindings {
        private CaseInsensitiveBindings(Map<String, Object> m) {
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                this.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.get(((String)key).toLowerCase());
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.containsKey(((String)key).toLowerCase());
        }
    }

    protected static class FluentMap
    extends HashMap<String, Object> {
        protected FluentMap() {
        }

        public FluentMap with(String name, Object value) {
            this.put(name, value);
            return this;
        }
    }
}

