/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.Document;
import com.day.util.diff.DocumentSource;
import com.day.util.diff.ElementsFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class WordsElementsFactory
implements ElementsFactory {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int MAX_ELEMENTS = 100000;
    private final Document.Element[] elements;

    public WordsElementsFactory(Document.Element[] elements) {
        this.elements = elements;
    }

    public Document.Element[] getElements() {
        return this.elements;
    }

    public static WordsElementsFactory create(DocumentSource source, String text) {
        try {
            StringReader reader = new StringReader(text);
            return WordsElementsFactory.create(source, reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static WordsElementsFactory create(DocumentSource source, Reader text) throws IOException {
        Document.Element[] elements = WordsElementsFactory.getElements(source, text);
        return new WordsElementsFactory(elements);
    }

    private static Document.Element[] getElements(DocumentSource source, Reader text) throws IOException {
        int c;
        BufferedReader r = text instanceof BufferedReader ? (BufferedReader)text : new BufferedReader(text);
        ArrayList<WordElement> lines = new ArrayList<WordElement>();
        StringBuffer gutter = new StringBuffer();
        StringBuffer word = new StringBuffer();
        while ((c = r.read()) >= 0 && lines.size() < 100000) {
            if (Character.isLetterOrDigit((char)c)) {
                if (gutter.length() > 0) {
                    lines.add(new WordElement(source, word.toString(), gutter.toString()));
                    gutter.setLength(0);
                    word.setLength(0);
                }
                word.append((char)c);
                continue;
            }
            gutter.append((char)c);
        }
        if (word.length() > 0) {
            lines.add(new WordElement(source, word.toString(), gutter.toString()));
        }
        return lines.toArray(new WordElement[lines.size()]);
    }

    public static class WordElement
    implements Document.Element {
        private final DocumentSource source;
        private final String word;
        private final String gutter;

        public WordElement(DocumentSource source, String word, String gutter) {
            this.source = source;
            this.word = word;
            this.gutter = gutter;
        }

        public String getString() {
            return this.word + this.gutter;
        }

        public DocumentSource getDocumentSource() {
            return this.source;
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public String toString() {
            return this.getString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WordElement) {
                return ((WordElement)obj).word.equals(this.word);
            }
            return false;
        }
    }
}

