/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import java.io.IOException;
import java.io.Writer;

public class DiffWriter
extends Writer {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    public static final String LS_NATIVE = System.getProperty("line.separator");
    public static final String LS_UNIX = "\n";
    public static final String LS_WINDOWS = "\r\n";
    private final Writer out;
    private String lineSeparator = LS_NATIVE;

    public DiffWriter(Writer out) {
        this.out = out;
    }

    public DiffWriter(Writer out, String lineSeparator) {
        this.out = out;
        this.lineSeparator = lineSeparator;
    }

    public void writeNewLine() throws IOException {
        this.write(this.lineSeparator);
    }

    public void write(int c) throws IOException {
        this.out.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.out.write(cbuf);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        this.out.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

