/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.ChangeListener;
import com.day.util.diff.Document;
import java.io.PrintWriter;

public class DefaultChangeListener
implements ChangeListener {
    private final PrintWriter out;
    private boolean debug;

    public DefaultChangeListener(PrintWriter out) {
        this.out = out;
    }

    public DefaultChangeListener(PrintWriter out, boolean debug) {
        this.out = out;
        this.debug = debug;
    }

    public void onDocumentsStart(Document left, Document right) {
        this.out.println("Start Diff");
    }

    public void onDocumentsEnd(Document left, Document right) {
        this.out.println("End Diff");
    }

    public void onChangeStart(int leftLine, int leftLen, int rightLine, int rightLen) {
        this.out.println("@@ -" + (leftLine + 1) + "," + leftLen + " +" + (rightLine + 1) + "," + rightLen + " @@");
    }

    public void onChangeEnd() {
        this.out.flush();
    }

    public void onUnmodified(int leftLine, int rightLine, Document.Element text) {
        if (this.debug) {
            this.out.print("(" + (leftLine + 1) + "," + (rightLine + 1) + ") ");
        }
        this.out.println(text);
    }

    public void onDeleted(int leftLine, int rightLine, Document.Element text) {
        if (this.debug) {
            this.out.print("(" + (leftLine + 1) + "," + (rightLine + 1) + ") ");
        }
        this.out.print("-");
        this.out.println(text);
    }

    public void onInserted(int leftLine, int rightLine, Document.Element text) {
        if (this.debug) {
            this.out.print("(" + (leftLine + 1) + "," + (rightLine + 1) + ") ");
        }
        this.out.print("+");
        this.out.println(text);
    }
}

