/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timing {
    public static final String DEFAULT_NAME = "Timing";
    private static final String TIMING_LOGGER = "misc.timing";
    private static final Logger timeLog = LoggerFactory.getLogger((String)"misc.timing");
    private String name;
    private long startTime;

    public Timing() {
        this(null);
    }

    public Timing(String name) {
        this.reset();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    public long getElapsed() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void stamp(String message) {
        timeLog.info("{}: {} - {}ms", (Object[])new String[]{this.name, message, String.valueOf(this.getElapsed())});
    }

    public String toString() {
        return "Timing: name=" + this.name + ", startTime=" + new Date(this.startTime);
    }
}

